/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.CatalogInstantBlock;
import io.intino.sumus.box.displays.OlapDisplay;
import io.intino.sumus.box.displays.PanelViewDisplay;
import io.intino.sumus.box.displays.notifiers.PanelOlapViewDisplayNotifier;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.RenderOlap;
import java.util.List;

public class PanelOlapViewDisplay
extends PanelViewDisplay<PanelOlapViewDisplayNotifier> {
    public PanelOlapViewDisplay(SumusBox box) {
        super(box);
    }

    protected void init() {
        super.init();
        this.createOlapDisplay();
    }

    private void createOlapDisplay() {
        Panel.View rawView = (Panel.View)((Object)this.view().raw());
        RenderOlap render = (RenderOlap)rawView.elementRender().a$(RenderOlap.class);
        Olap olap = render.olap();
        OlapDisplay display = new OlapDisplay(this.box);
        display.nameSpaceHandler(this.provider().nameSpaceHandler());
        display.olap(olap);
        display.onLoading(this::notifyLoading);
        display.onSelect(this::selectInstant);
        this.add(display);
        display.personifyOnce(this.id());
    }

    private void selectInstant(CatalogInstantBlock block) {
        CatalogDisplay display = (CatalogDisplay)this.provider().openElement(block.catalog());
        List<String> entities = block.entities();
        display.filterAndNotify(record -> entities.contains(((Record)((Object)((Object)record))).core$().id()));
        display.refreshView();
    }
}

