/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ElementDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.PanelCatalogViewDisplay;
import io.intino.sumus.box.displays.PanelCustomViewDisplay;
import io.intino.sumus.box.displays.PanelOlapViewDisplay;
import io.intino.sumus.box.displays.PanelViewDisplay;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.notifiers.PanelDisplayNotifier;
import io.intino.sumus.box.displays.providers.ElementViewDisplayProvider;
import io.intino.sumus.box.schemas.Item;
import io.intino.sumus.graph.AbstractView;
import io.intino.sumus.graph.ElementRender;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.OnClickRecord;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.RenderCatalog;
import io.intino.sumus.graph.RenderMold;
import io.intino.sumus.graph.RenderOlap;
import io.intino.sumus.graph.Toolbar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PanelDisplay
extends ElementDisplay<Panel, PanelDisplayNotifier>
implements ElementViewDisplayProvider {
    protected Map<Class<? extends ElementRender>, Function<ElementRender, PanelViewDisplay>> displayBuilders = new HashMap<Class<? extends ElementRender>, Function<ElementRender, PanelViewDisplay>>();
    private Map<String, PanelViewDisplay> viewDisplayMap = new HashMap<String, PanelViewDisplay>();
    private static final String ViewId = "%s%s";

    public PanelDisplay(SumusBox box) {
        super(box);
        this.registerBuilders();
    }

    @Override
    protected void refreshBreadcrumbs(String breadcrumbs) {
        ((PanelDisplayNotifier)this.notifier).refreshBreadcrumbs(breadcrumbs);
    }

    @Override
    protected void createPanel(String item) {
        ((PanelDisplayNotifier)this.notifier).createPanel(item);
    }

    @Override
    protected void showPanel() {
        ((PanelDisplayNotifier)this.notifier).showPanel();
    }

    @Override
    protected void hidePanel() {
        ((PanelDisplayNotifier)this.notifier).hidePanel();
    }

    @Override
    protected void showDialog() {
        ((PanelDisplayNotifier)this.notifier).showDialog();
    }

    @Override
    protected void currentRecord(String id) {
    }

    @Override
    protected Record currentRecord() {
        return this.target();
    }

    @Override
    protected void notifyFiltered(boolean value) {
    }

    @Override
    protected void selectNameSpace(NameSpace nameSpace) {
    }

    @Override
    protected Record loadRecord(String id) {
        return this.queryEngine().record(id, this.username());
    }

    protected void init() {
        super.init();
        this.sendTarget();
        this.sendViewList();
        this.createDialogContainer();
        if (this.views().size() > 0) {
            this.selectView(this.views().get(0).name$());
        }
    }

    private void sendTarget() {
        if (this.target() == null) {
            return;
        }
        ((PanelDisplayNotifier)this.notifier).refreshTarget(this.target().name$());
    }

    private void sendViewList() {
        ((PanelDisplayNotifier)this.notifier).refreshViewList(this.views().stream().map(this::itemOf).collect(Collectors.toList()));
    }

    private Item itemOf(AbstractView view) {
        return ItemBuilder.build(view);
    }

    private void registerBuilders() {
        this.displayBuilders.put(RenderMold.class, this::buildCustomViewDisplay);
        this.displayBuilders.put(RenderCatalog.class, this::buildCatalogViewDisplay);
        this.displayBuilders.put(RenderOlap.class, this::buildOlapViewDisplay);
    }

    private PanelCustomViewDisplay buildCustomViewDisplay(ElementRender render) {
        return new PanelCustomViewDisplay(this.box);
    }

    private PanelCatalogViewDisplay buildCatalogViewDisplay(ElementRender render) {
        return new PanelCatalogViewDisplay(this.box);
    }

    private PanelOlapViewDisplay buildOlapViewDisplay(ElementRender render) {
        return new PanelOlapViewDisplay(this.box);
    }

    public void selectView(String name) {
        PanelViewDisplay viewDisplay = this.buildView(name);
        viewDisplay.refresh();
        this.updateCurrentView(viewDisplay);
    }

    private PanelViewDisplay buildView(String name) {
        if (this.viewDisplayMap.containsKey(name)) {
            this.viewDisplayMap.get(name);
        }
        this.notifyLoading(true);
        PanelViewDisplay display = this.buildView((AbstractView)this.views().stream().filter((? super T v) -> v.name$().equals(name)).findFirst().orElse(null));
        this.viewDisplayMap.put(name, display);
        this.notifyLoading(false);
        return display;
    }

    private PanelViewDisplay buildView(AbstractView view) {
        Panel.View panelView = (Panel.View)view.a$(Panel.View.class);
        ElementRender render = panelView.elementRender();
        PanelViewDisplay display = this.displayBuilders.get(((Object)((Object)render)).getClass()).apply(render);
        display.provider(this);
        display.view(this.panelViewOf(panelView));
        display.context((Panel)((Object)this.element()));
        display.target(this.target());
        display.onLoading(v -> this.notifyLoading((Boolean)v));
        display.onOpenItem(params -> this.openItem((ElementViewDisplay.OpenItemEvent)params));
        display.onOpenItemDialog(params -> this.openItemDialog((ElementViewDisplay.OpenItemDialogEvent)params));
        display.onExecuteItemTask(params -> this.executeItemTask((ElementViewDisplay.ExecuteItemTaskEvent)params));
        this.add(display);
        display.personifyOnce(this.viewId(view));
        return display;
    }

    private String viewId(AbstractView view) {
        if (this.target() == null) {
            return view.name$();
        }
        return String.format(ViewId, this.target().name$(), view.name$());
    }

    @Override
    public void navigate(String key) {
        super.navigate(key);
    }

    protected ElementView<Panel> panelViewOf(final Panel.View view) {
        return new ElementView<Panel>(){

            @Override
            public String name() {
                return view.core$().name();
            }

            @Override
            public String label() {
                return view.label();
            }

            @Override
            public String type() {
                return ((Object)((Object)view)).getClass().getSimpleName();
            }

            @Override
            public String option() {
                return null;
            }

            @Override
            public <V extends AbstractView> V raw() {
                return (V)((Object)view);
            }

            @Override
            public boolean embeddedElement() {
                return PanelDisplay.this.embedded();
            }

            @Override
            public Toolbar toolbar() {
                return this.element().toolbar();
            }

            @Override
            public int width() {
                return 100;
            }

            @Override
            public Mold mold() {
                ElementRender render = view.elementRender();
                if (render.i$(RenderMold.class)) {
                    return ((RenderMold)render.a$(RenderMold.class)).mold();
                }
                return null;
            }

            @Override
            public OnClickRecord onClickRecordEvent() {
                return null;
            }

            @Override
            public boolean canCreateClusters() {
                return false;
            }

            @Override
            public boolean canSearch() {
                return false;
            }

            @Override
            public List<String> clusters() {
                return Collections.emptyList();
            }

            @Override
            public Record target() {
                return PanelDisplay.this.target();
            }

            @Override
            public Panel element() {
                return (Panel)((Object)PanelDisplay.this.element());
            }

            @Override
            public String emptyMessage() {
                return null;
            }
        };
    }
}

