/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.EntityCatalogDisplay;
import io.intino.sumus.box.displays.EventCatalogDisplay;
import io.intino.sumus.box.displays.PanelViewDisplay;
import io.intino.sumus.box.displays.ReportCatalogDisplay;
import io.intino.sumus.box.displays.notifiers.PanelCatalogViewDisplayNotifier;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.RenderCatalog;
import java.util.Optional;

public class PanelCatalogViewDisplay
extends PanelViewDisplay<PanelCatalogViewDisplayNotifier> {
    public PanelCatalogViewDisplay(SumusBox box) {
        super(box);
    }

    protected void init() {
        super.init();
        this.createCatalogDisplay();
    }

    private void createCatalogDisplay() {
        Panel.View rawView = (Panel.View)((Object)this.view().raw());
        RenderCatalog render = (RenderCatalog)rawView.elementRender().a$(RenderCatalog.class);
        Catalog catalog = render.catalog();
        this.buildDisplay(catalog).ifPresent(display -> {
            display.filter(record -> render.filter(this.context(), this.target(), (Record)((Object)((Object)((Object)record)))));
            display.target(this.target());
            display.nameSpaceHandler(this.provider().nameSpaceHandler());
            display.elementDisplayManager(this.provider().elementDisplayManager());
            display.catalog(catalog);
            display.onLoading(value -> this.notifyLoading((Boolean)value));
            display.onOpenItem(params -> this.notifyOpenItem((ElementViewDisplay.OpenItemEvent)params));
            this.add((Display)display);
            display.personifyOnce(this.id());
        });
    }

    private Optional<CatalogDisplay> buildDisplay(Catalog catalog) {
        if (catalog.isEventHolder()) {
            return Optional.of(new EventCatalogDisplay(this.box));
        }
        if (catalog.isReportHolder()) {
            return Optional.of(new ReportCatalogDisplay(this.box));
        }
        if (catalog.isEntityHolder()) {
            return Optional.of(new EntityCatalogDisplay(this.box));
        }
        return Optional.empty();
    }
}

