/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.spark.ActivityFile;
import io.intino.sumus.Category;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.categorization.TemporalCategorizationFactory;
import io.intino.sumus.analytics.exporters.Document;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.AnalyzeDisplay;
import io.intino.sumus.box.displays.CatalogInstantBlock;
import io.intino.sumus.box.displays.ChartDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.TimeBarChartDisplay;
import io.intino.sumus.box.displays.TimeCrossTableDisplay;
import io.intino.sumus.box.displays.TimeScatterChartDisplay;
import io.intino.sumus.box.displays.TimeSeriesChartDisplay;
import io.intino.sumus.box.displays.builders.DrillBuilder;
import io.intino.sumus.box.displays.builders.FilterBuilder;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.builders.RangeBuilder;
import io.intino.sumus.box.displays.builders.ScaleBuilder;
import io.intino.sumus.box.displays.builders.TicketBuilder;
import io.intino.sumus.box.displays.notifiers.OlapDisplayNotifier;
import io.intino.sumus.box.schemas.Chart;
import io.intino.sumus.box.schemas.ChartOption;
import io.intino.sumus.box.schemas.RequestRange;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Distribution;
import io.intino.sumus.graph.Indicator;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.StackedIndicator;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.Bounds;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.helpers.ChartSpecHandler;
import io.intino.sumus.helpers.NameSpaceHandler;
import io.intino.sumus.helpers.TimeScaleHandler;
import io.intino.tara.magritte.Concept;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class OlapDisplay
extends SumusDisplay<OlapDisplayNotifier> {
    private static final Logger LOG = Logger.getLogger(OlapDisplay.class.getName());
    private Olap olap;
    private NameSpaceHandler nameSpaceHandler;
    private TimeScaleHandler timeScaleHandler;
    private ChartSpecHandler chartSpecHandler;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<CatalogInstantBlock>> selectListeners = new ArrayList<Consumer<CatalogInstantBlock>>();
    private Map<io.intino.sumus.graph.rules.Chart, Function<io.intino.sumus.graph.rules.Chart, ChartDisplay>> chartDisplayBuilders = new HashMap<io.intino.sumus.graph.rules.Chart, Function<io.intino.sumus.graph.rules.Chart, ChartDisplay>>();
    private Map<io.intino.sumus.graph.rules.Chart, ChartDisplay> chartDisplayMap = new HashMap<io.intino.sumus.graph.rules.Chart, ChartDisplay>();
    private io.intino.sumus.graph.rules.Chart selectedChart = null;
    private List<Ticket> lastSelectedTickets = new ArrayList<Ticket>();
    private Concept context = null;

    public OlapDisplay(SumusBox box) {
        super(box);
        this.fillBuilders();
    }

    public void context(Concept entity) {
        this.context = entity;
    }

    public OlapDisplay olap(Olap olap) {
        this.olap = olap;
        return this;
    }

    public Olap olap() {
        return this.olap;
    }

    public void nameSpaceHandler(NameSpaceHandler nameSpaceHandler) {
        this.nameSpaceHandler = nameSpaceHandler;
        this.nameSpaceHandler.onSelect(this::selectNameSpace);
    }

    public void refresh() {
        super.refresh();
        this.chartDisplay().ifPresent(ChartDisplay::update);
        this.updateActions();
    }

    public void addTicket(String label) {
        if (label == null) {
            return;
        }
        this.addTicket(this.ticket(label));
    }

    public void addTicket(Ticket ticket) {
        this.chartSpecHandler.addTicket(ticket);
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        if (selectedTickets.size() == 1) {
            this.notifyShowChart();
        }
        this.checkEnabledDrill(this.canDrill());
        this.checkEnabledFilter(this.canFilter());
        this.updateAnalyzeDisplay();
        this.updateTickets();
        this.chartSpecHandler.update();
    }

    public void removeTicket(String label) {
        if (label == null) {
            return;
        }
        this.removeTicket(this.ticket(label));
    }

    public void removeTicket(Ticket ticket) {
        this.chartSpecHandler.removeTicket(ticket);
        this.checkEnabledDrill(this.canDrill());
        this.checkEnabledFilter(this.canFilter());
        this.updateTickets();
        this.updateAnalyzeDisplay();
        this.chartSpecHandler.update();
    }

    public void moveTickets(String[] tickets) {
        this.chartSpecHandler.selectTickets(tickets);
        this.chartSpecHandler.update();
    }

    public void updateScale(String scale) {
        this.updateScale(TimeScale.valueOf(scale));
    }

    public void updateScale(TimeScale scale) {
        this.timeScaleHandler.updateScale(scale);
    }

    public ActivityFile export(final RequestRange range) {
        return new ActivityFile(){
            private Document document;
            {
                this.document = OlapDisplay.this.export(range.from(), range.to());
            }

            public String label() {
                return this.document.name();
            }

            public InputStream content() {
                return this.document.content();
            }
        };
    }

    public void drill(Categorization categorization, List<Category> categories) {
        Drill drill = new Drill(categorization, categories);
        this.chartSpecHandler.drill(drill);
        ((OlapDisplayNotifier)this.notifier).refreshDrill(DrillBuilder.build(drill));
        this.chartSpecHandler.update();
    }

    public void removeDrillCategory(String categoryName) {
        Drill drill = this.chartSpecHandler.removeDrillCategory(categoryName);
        if (drill.categories.size() <= 0) {
            this.removeDrill();
            return;
        }
        ((OlapDisplayNotifier)this.notifier).refreshDrill(DrillBuilder.build(drill));
        this.updateActions();
        this.chartSpecHandler.update();
    }

    public void removeDrill() {
        this.chartSpecHandler.drill(null);
        ((OlapDisplayNotifier)this.notifier).refreshDrill(null);
        this.chartSpecHandler.update();
    }

    public void selectNameSpace(NameSpace nameSpace) {
        this.children(ChartDisplay.class).forEach(display -> display.nameSpace(nameSpace));
        if (this.selectedChart != null) {
            this.chartDisplay().ifPresent(Display::refresh);
        }
    }

    public void selectChart(ChartOption option) {
        this.selectChart(io.intino.sumus.graph.rules.Chart.valueOf(option.name()), option.option());
    }

    public void selectChart(io.intino.sumus.graph.rules.Chart chart, String option) {
        this.selectedChart = chart;
        ((OlapDisplayNotifier)this.notifier).selectChart(chart.toString());
        ChartDisplay chartDisplay = this.chartDisplay().get();
        if (this.analyzeDisplay().isPresent()) {
            AnalyzeDisplay display = this.analyzeDisplay().get();
            display.allowTemporalCategorizations(chartDisplay.allowTemporalFiltering());
            display.selectChart(chart);
        }
        if (!chartDisplay.isValidSpecification(this.chartSpecHandler.specification())) {
            ((OlapDisplayNotifier)this.notifier).openAnalyzeDialog();
        } else {
            ((OlapDisplayNotifier)this.notifier).closeAnalyzeDialog();
        }
        if (chartDisplay.allowDrill()) {
            this.removeDrill();
        } else if (this.chartSpecHandler.drill() != null) {
            this.removeDrill();
        }
        chartDisplay.specification(this.chartSpecHandler.specification());
        this.updateByCategorization();
        this.updateCompare();
    }

    public void updateRange(RequestRange range) {
        this.updateRange(range.from(), range.to());
    }

    public void updateRange(Instant from, Instant to) {
        this.timeScaleHandler.updateRange(from, to);
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void onSelect(Consumer<CatalogInstantBlock> listener) {
        this.selectListeners.add(listener);
    }

    public void removeFilter(String value) {
        this.analyzeDisplay().ifPresent(d -> d.quitFilter(value));
    }

    private List<Catalog> catalogs() {
        if (this.olap.events() != null && this.olap.events().onClickInstant() != null) {
            return this.olap.events().onClickInstant().catalogs();
        }
        return this.findSelectInstantCatalogs();
    }

    private List<Catalog> findSelectInstantCatalogs() {
        List<Concept> conceptList = this.indicatorEntities();
        return this.box.graph().catalogList().stream().filter((? super T c) -> this.holds((Catalog)((Object)c), conceptList) && this.hasAvailableView((Catalog)((Object)c))).collect(Collectors.toList());
    }

    private boolean hasAvailableView(Catalog c) {
        return c.view() != null && !c.view().i$(Catalog.OlapView.class) || c.views() != null && c.views().viewList().stream().anyMatch(v -> !v.i$(Catalog.OlapView.class));
    }

    protected void init() {
        super.init();
        this.setupOlap();
        this.sendCharts();
        this.sendRanges();
        this.addTicket(this.olap.select().ticket());
    }

    private static Stream<Indicator> indicators(List<Ticket> tickets) {
        return tickets.stream().filter((? super T ticket) -> ticket.dataRetriever().i$(Indicator.class)).map(ticket -> ticket.dataRetriever().i$(MeasureIndicator.class) ? Collections.singletonList(ticket.dataRetriever().a$(MeasureIndicator.class)) : ((StackedIndicator)ticket.dataRetriever().a$(StackedIndicator.class)).measureIndicatorList()).flatMap(Collection::stream);
    }

    private void checkZoomsAndTicketsScales(List<Olap.ZoomGroup.Zoom> zooms, List<TimeScale> scales) {
        if (zooms.size() != scales.size()) {
            LOG.severe(String.format("Olap %s: The number of scales defined by tickets are different from available zoom levels. It must be the same", this.olap.name$()));
        }
        zooms.forEach(zoom -> {
            if (scales.contains((Object)zoom.scale())) {
                return;
            }
            LOG.severe(String.format("Olap %s: Scale %s not defined by tickets.", this.olap.name$(), zoom.scale().toString()));
        });
    }

    private void drill(List<Drill> drills, boolean includeGlobalSerie) {
        Drill drill = drills.size() > 0 ? drills.get(0) : null;
        this.chartSpecHandler.drill(drill, includeGlobalSerie);
        ((OlapDisplayNotifier)this.notifier).refreshDrill(DrillBuilder.build(drill));
        this.chartSpecHandler.update();
    }

    private void checkEnabledDrill(boolean enabled) {
        if (enabled && this.canDrill()) {
            ((OlapDisplayNotifier)this.notifier).enableDrill();
        } else {
            ((OlapDisplayNotifier)this.notifier).disableDrill();
        }
    }

    private void checkEnabledFilter(boolean enabled) {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        if (enabled && this.canFilter() && OlapDisplay.indicators(selectedTickets).count() > 0L) {
            ((OlapDisplayNotifier)this.notifier).enableFilter();
        } else {
            ((OlapDisplayNotifier)this.notifier).disableFilter();
        }
    }

    private void updateAnalyzeDisplay() {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        if (!selectedTickets.isEmpty()) {
            return;
        }
        this.analyzeDisplay().ifPresent(AnalyzeDisplay::quitFilters);
        this.updateActions();
        if (this.analyzeDisplay().isPresent()) {
            ((OlapDisplayNotifier)this.notifier).refreshFilterList(FilterBuilder.buildList(this.analyzeDisplay().get().filterList()));
        }
    }

    private void updateActions() {
        if (this.isFiltering()) {
            ((OlapDisplayNotifier)this.notifier).filtering();
            if (this.canDrill()) {
                ((OlapDisplayNotifier)this.notifier).enableDrill();
            } else {
                ((OlapDisplayNotifier)this.notifier).disableDrill();
            }
        } else if (this.isDrilling()) {
            ((OlapDisplayNotifier)this.notifier).drilling();
        } else {
            ((OlapDisplayNotifier)this.notifier).notDrilling();
            ((OlapDisplayNotifier)this.notifier).notFiltering();
            this.checkEnabledDrill(this.canDrill());
            if (this.canFilter()) {
                ((OlapDisplayNotifier)this.notifier).enableFilter();
            } else {
                ((OlapDisplayNotifier)this.notifier).disableFilter();
            }
        }
    }

    private void updateCompare() {
        boolean allowDrill;
        if (!this.analyzeDisplay().isPresent()) {
            return;
        }
        AnalyzeDisplay analyzeDisplay = this.analyzeDisplay().get();
        boolean bl = allowDrill = this.chartDisplay().isPresent() && this.chartDisplay().get().allowDrill();
        if (this.canDrill() && allowDrill) {
            analyzeDisplay.enableComparePanel();
        } else {
            analyzeDisplay.disableComparePanel();
        }
    }

    private void updateTickets() {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        List<Ticket> ticketList = this.ticketList();
        this.lastSelectedTickets.clear();
        this.lastSelectedTickets.addAll(selectedTickets);
        ((OlapDisplayNotifier)this.notifier).ticketList(TicketBuilder.buildList(ticketList));
        ((OlapDisplayNotifier)this.notifier).selectTicketList(TicketBuilder.buildList(selectedTickets));
    }

    private void updateByCategorization() {
        this.chartDisplay().ifPresent(chartDisplay -> {
            Categorization byCategorization = chartDisplay.byCategorization();
            ((OlapDisplayNotifier)this.notifier).byCategorization(byCategorization != null ? ItemBuilder.build(byCategorization) : null);
        });
    }

    private List<Ticket> ticketList() {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        return this.olap.tickets().stream().filter((? super T t) -> !selectedTickets.contains(t)).collect(Collectors.toList());
    }

    private void notifyShowChart() {
        if (this.analyzeDisplay().isPresent()) {
            return;
        }
        if (this.olap.charts().size() > 0) {
            this.selectChart(this.olap.charts().get(0), null);
        }
        ((OlapDisplayNotifier)this.notifier).scaleList(ScaleBuilder.buildList(this.localizedScales(), this.currentLanguage()));
        this.buildAnalyzeDisplay();
        this.updateScale(this.olap.select().scale());
    }

    private void buildAnalyzeDisplay() {
        AnalyzeDisplay analyzeDisplay = new AnalyzeDisplay(this.box);
        analyzeDisplay.timeScaleHandler(this.timeScaleHandler);
        analyzeDisplay.chartSpecHandler(this.chartSpecHandler);
        this.add(analyzeDisplay);
        analyzeDisplay.personifyOnce();
        analyzeDisplay.onFilter(this::filter);
        analyzeDisplay.onDrill(this::drill);
        analyzeDisplay.allowTemporalCategorizations(this.chartDisplay().isPresent() && this.chartDisplay().get().allowTemporalFiltering());
        analyzeDisplay.selectChart(this.selectedChart);
        this.updateTemporalCategorizations(this.timeScaleHandler.range());
    }

    private void filter(List<FilterCondition> conditions) {
        this.chartSpecHandler.filter(conditions);
        if (this.analyzeDisplay().isPresent()) {
            ((OlapDisplayNotifier)this.notifier).refreshFilterList(FilterBuilder.buildList(this.analyzeDisplay().get().filterList()));
        }
        this.chartSpecHandler.update();
    }

    private void notifyLoading(Boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    private void refreshOlapAndTemporalCategorizations(TimeRange timeRange) {
        this.refreshOlap(timeRange);
        this.updateTemporalCategorizations(timeRange);
    }

    private void refreshOlap(TimeRange timeRange) {
        ((OlapDisplayNotifier)this.notifier).updateScale(ScaleBuilder.build(this.scaleWithLabel(timeRange.scale()), this.currentLanguage()));
        ((OlapDisplayNotifier)this.notifier).timeRange(RangeBuilder.build(timeRange));
        this.refresh();
    }

    private void updateTemporalCategorizations(TimeRange timeRange) {
        List<TemporalCategorization> temporalCategorizations = this.temporalCategorizations(timeRange);
        this.chartSpecHandler.olapTemporalCategorizations(temporalCategorizations);
        Optional.ofNullable(this.child(AnalyzeDisplay.class)).ifPresent(ad -> ad.updateTemporalCategorizations(temporalCategorizations));
    }

    private void sendCharts() {
        ((OlapDisplayNotifier)this.notifier).chartList(this.olap.charts().stream().map(this::chartOf).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private Chart chartOf(io.intino.sumus.graph.rules.Chart chart) {
        return new Chart().name(chart.toString());
    }

    private void sendRanges() {
        ((OlapDisplayNotifier)this.notifier).olapRange(RangeBuilder.build(this.timeScaleHandler.boundsRange()));
        ((OlapDisplayNotifier)this.notifier).timeRange(RangeBuilder.build(this.timeScaleHandler.range()));
    }

    private Optional<AnalyzeDisplay> analyzeDisplay() {
        return Optional.ofNullable(this.child(AnalyzeDisplay.class));
    }

    private Optional<ChartDisplay> chartDisplay() {
        return Optional.ofNullable(this.chartDisplay(this.selectedChart));
    }

    private ChartDisplay chartDisplay(io.intino.sumus.graph.rules.Chart chart) {
        if (chart == null) {
            return null;
        }
        if (!this.chartDisplayMap.containsKey((Object)chart)) {
            this.chartDisplayMap.put(chart, this.chartDisplayBuilders.get((Object)chart).apply(chart));
        }
        return this.chartDisplayMap.get((Object)chart);
    }

    private List<TimeScale> scalesFrom(List<Ticket> tickets) {
        return tickets.stream().map(Ticket::range).flatMap(this::scalesInRange).distinct().sorted().collect(Collectors.toList());
    }

    private Stream<TimeScale> scalesInRange(Ticket.Range range) {
        return IntStream.rangeClosed(range.max().ordinal(), range.min().ordinal()).mapToObj(i -> TimeScale.values()[i]);
    }

    private List<TimeScale> localizedScales() {
        return this.localizedScales(this.timeScaleHandler.scales());
    }

    private Document export(Instant from, Instant to) {
        return this.chartDisplay().isPresent() ? this.chartDisplay().get().export(from, to) : null;
    }

    private boolean isFiltering() {
        return this.analyzeDisplay().isPresent() && this.analyzeDisplay().get().filterList().size() <= 0;
    }

    private boolean canFilter() {
        return !this.isDrilling() && this.analyzeDisplay().isPresent() && this.analyzeDisplay().get().filterList().size() > 0;
    }

    private boolean isDrilling() {
        return this.chartSpecHandler.drill() != null;
    }

    private boolean canDrill() {
        List<Ticket> selectedTickets = this.chartSpecHandler.selectedTickets();
        return OlapDisplay.indicators(selectedTickets).count() == 1L && this.chartDisplay().isPresent() && !this.chartDisplay().get().isShowingEvents();
    }

    private Ticket ticket(String label) {
        return this.platform().ticketList().stream().filter((? super T b) -> b.label().equals(label)).findFirst().orElse(null);
    }

    private void fillBuilders() {
        this.chartDisplayBuilders.put(io.intino.sumus.graph.rules.Chart.TimeSeriesChart, this::buildTimeSeriesChartDisplay);
        this.chartDisplayBuilders.put(io.intino.sumus.graph.rules.Chart.TimeCrossTable, this::buildTimeCrossTableDisplay);
        this.chartDisplayBuilders.put(io.intino.sumus.graph.rules.Chart.TimeBarChart, this::buildTimeBarChartDisplay);
        this.chartDisplayBuilders.put(io.intino.sumus.graph.rules.Chart.TimeScatterChart, this::buildTimeScatterChartDisplay);
    }

    private ChartDisplay buildTimeSeriesChartDisplay(io.intino.sumus.graph.rules.Chart chart) {
        TimeSeriesChartDisplay display = this.init(new TimeSeriesChartDisplay(this.box));
        display.catalogs(this.catalogs());
        this.addAndPersonify(display);
        this.timeScaleHandler.onRangeChange(this::refreshOlapAndTemporalCategorizations);
        this.timeScaleHandler.onScaleChange(this::refreshOlapAndTemporalCategorizations);
        return display;
    }

    private boolean holds(Catalog catalog, List<Concept> conceptList) {
        return conceptList.stream().anyMatch(ic -> ic.is(this.holderConceptOf(catalog).name()));
    }

    private ChartDisplay buildTimeCrossTableDisplay(io.intino.sumus.graph.rules.Chart chart) {
        TimeCrossTableDisplay display = this.addAndPersonify(this.init(new TimeCrossTableDisplay(this.box)));
        this.updateTemporalCategorizations(this.timeScaleHandler.range());
        return display;
    }

    private TimeBarChartDisplay buildTimeBarChartDisplay(io.intino.sumus.graph.rules.Chart chart) {
        return this.addAndPersonify(this.init(new TimeBarChartDisplay(this.box)));
    }

    private TimeScatterChartDisplay buildTimeScatterChartDisplay(io.intino.sumus.graph.rules.Chart chart) {
        return this.addAndPersonify(this.init(new TimeScatterChartDisplay(this.box)));
    }

    private <D extends ChartDisplay> D init(D display) {
        display.timeScaleHandler(this.timeScaleHandler);
        display.chartSpecHandler(this.chartSpecHandler);
        display.nameSpace(this.nameSpaceHandler.selectedNameSpace(this.username()));
        display.instantFormatter(this.olap.instantFormatter());
        display.onShowDialog(value -> ((OlapDisplayNotifier)this.notifier).openAnalyzeDialog());
        display.onSelect(instant -> this.notifySelectInstant((CatalogInstantBlock)instant));
        display.onLoading(value -> this.notifyLoading((Boolean)value));
        return display;
    }

    private <D extends ChartDisplay> D addAndPersonify(D display) {
        this.add(display);
        display.personifyOnce();
        return display;
    }

    private void notifySelectInstant(CatalogInstantBlock instant) {
        this.selectListeners.forEach(l -> l.accept(instant));
    }

    private List<Categorization> categorizations() {
        List<Concept> indicatorEntities = this.indicatorEntities();
        List<Concept> distributionEntities = this.distributionEntities();
        return this.box.graph().categorizationList().stream().filter((? super T c) -> this.isContained(indicatorEntities, c.record()) || this.isContained(distributionEntities, c.record())).collect(Collectors.toList());
    }

    private boolean isContained(List<Concept> indicatorEntities, Concept concept) {
        for (Concept entity : indicatorEntities) {
            if (!entity.is(concept.name())) continue;
            return true;
        }
        return false;
    }

    private List<Concept> indicatorEntities() {
        return this.olap.tickets().stream().map(ticket -> ticket.core$().findNode(MeasureIndicator.Formula.class)).map(formulas -> formulas.stream().map(MeasureIndicator.Formula::cube).collect(Collectors.toList())).flatMap(Collection::stream).map(Cube::dimensionList).flatMap(Collection::stream).map(Cube.Dimension::entity).distinct().collect(Collectors.toList());
    }

    private List<Concept> distributionEntities() {
        return this.olap.tickets().stream().map(ticket -> ticket.core$().findNode(Distribution.Source.class)).flatMap(Collection::stream).map(source -> ((Cube)source.property().core$().ownerAs(Cube.class)).dimensionList()).flatMap(Collection::stream).map(Cube.Dimension::entity).distinct().collect(Collectors.toList());
    }

    private List<TemporalCategorization> temporalCategorizations(TimeRange range) {
        List<TimeScale> timeScales = this.scalesFrom(this.olap.tickets());
        return timeScales.stream().map(scale -> this.temporalCategorization(this.rangeForScale(range, (TimeScale)((Object)scale)))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private TimeRange rangeForScale(TimeRange range, TimeScale scale) {
        TimeScale rangeScale = range.scale();
        if (scale.ordinal() <= rangeScale.ordinal()) {
            return new TimeRange(range.from(), range.to(), scale);
        }
        Instant instant = rangeScale.addTo(range.to(), 1L);
        instant = rangeScale.next().addTo(instant, -1L);
        return new TimeRange(range.from(), instant, scale);
    }

    private List<TemporalCategorization> temporalCategorization(TimeRange range) {
        TemporalCategorization result = new TemporalCategorizationFactory().get(range);
        result.helper(this.box.translatorHelper()).language(this.currentLanguage());
        return Collections.singletonList(result);
    }

    private TimeScaleHandler buildTimeScaleHandler(Olap olap, List<Olap.ZoomGroup.Zoom> zooms, List<TimeScale> scales) {
        TimeScaleHandler.Bounds bounds = new TimeScaleHandler.Bounds();
        Olap.Range range = olap.range();
        String username = this.username();
        bounds.range(new TimeRange(range.from(username), range.to(username), TimeScale.Minute));
        bounds.mode(olap.select().range());
        bounds.zooms(zooms.stream().filter((? super T zoom) -> scales.contains((Object)zoom.scale())).collect(Collectors.toMap(Olap.ZoomGroup.Zoom::scale, zoom -> new Bounds.Zoom((Olap.ZoomGroup.Zoom)((Object)zoom)){
            final /* synthetic */ Olap.ZoomGroup.Zoom val$zoom;
            {
                this.val$zoom = zoom;
            }

            @Override
            public int min() {
                return this.val$zoom.instantRange().min();
            }

            @Override
            public int max() {
                return this.val$zoom.instantRange().max();
            }
        })));
        TimeScaleHandler timeScaleHandler = new TimeScaleHandler(bounds, scales, olap.select().scale());
        timeScaleHandler.availableScales(this.localizedScales(scales));
        timeScaleHandler.onRangeChange(r -> this.chartSpecHandler.range((TimeRange)r));
        timeScaleHandler.onNotValidRange(r -> this.chartSpecHandler.range((TimeRange)r));
        timeScaleHandler.onScaleChange(r -> this.chartSpecHandler.range((TimeRange)r));
        return timeScaleHandler;
    }

    private ChartSpecHandler buildChartSpecHandler() {
        ChartSpecHandler result = new ChartSpecHandler();
        result.olapTickets(this.olap.tickets());
        result.olapCategorizations(this.categorizations());
        result.olapTemporalCategorizations(this.temporalCategorizations(this.timeScaleHandler.range()));
        result.onChange(this::refreshSelectedChartDesign);
        return result;
    }

    private void refreshSelectedChartDesign(ChartSpec chartSpec) {
        if (this.selectedChart == null) {
            return;
        }
        if (!chartSpec.equalsTickets(this.lastSelectedTickets)) {
            this.updateTickets();
        }
        this.updateByCategorization();
        this.chartDisplay().ifPresent(d -> {
            if (!d.isValidSpecification(chartSpec)) {
                ((OlapDisplayNotifier)this.notifier).openAnalyzeDialog();
            }
            d.specification(chartSpec);
        });
    }

    private void setupOlap() {
        List<Olap.ZoomGroup.Zoom> zooms = this.olap.zoomGroup().zoomList();
        List<TimeScale> scales = this.scalesFrom(this.olap.tickets());
        this.checkZoomsAndTicketsScales(zooms, scales);
        if (!scales.contains((Object)this.olap.select().scale())) {
            LOG.severe(String.format("Olap %s: Select scale %s not available", this.olap.name$(), this.olap.select().scale().toString()));
        }
        this.timeScaleHandler = this.buildTimeScaleHandler(this.olap, zooms, scales);
        this.chartSpecHandler = this.buildChartSpecHandler();
        this.olap.onRefresh(() -> {
            this.sendRanges();
            this.chartDisplay().ifPresent(Display::refresh);
        });
    }
}

