/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.konos.server.activity.services.push.User;
import io.intino.sumus.Settings;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.ElementRepositoryDisplay;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.builders.PlatformInfoBuilder;
import io.intino.sumus.box.schemas.ItemProperty;
import io.intino.sumus.box.schemas.PlatformInfo;
import io.intino.sumus.box.schemas.UserInfo;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.ElementOption;
import io.intino.sumus.graph.ElementRender;
import io.intino.sumus.graph.Group;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Option;
import io.intino.sumus.graph.Options;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.RenderCatalog;
import io.intino.sumus.graph.RenderCatalogs;
import io.intino.sumus.graph.RenderMold;
import io.intino.sumus.graph.RenderOlap;
import io.intino.sumus.graph.RenderPanel;
import io.intino.sumus.graph.RenderPanels;
import io.intino.sumus.graph.RenderRecord;
import io.intino.sumus.graph.RenderRecords;
import io.intino.sumus.graph.entityholder.EntityHolderCatalog;
import io.intino.sumus.graph.eventholder.EventHolderCatalog;
import io.intino.sumus.graph.reportholder.ReportHolderCatalog;
import io.intino.tara.magritte.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class LayoutDisplay<DN extends DisplayNotifier>
extends ElementRepositoryDisplay<DN> {
    private List<Item> items = new ArrayList<Item>();
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<Boolean>> loadedListeners = new ArrayList<Consumer<Boolean>>();
    protected Map<Class<? extends ElementRender>, Function<ElementRender, List<Item>>> itemsProviders = new HashMap<Class<? extends ElementRender>, Function<ElementRender, List<Item>>>();

    public LayoutDisplay(SumusBox box) {
        super(box);
        this.buildElementProviders();
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void onLoaded(Consumer<Boolean> listener) {
        this.loadedListeners.add(listener);
    }

    @Override
    protected void refreshLoading(boolean withMessage) {
        this.sendLoading();
        this.loadingListeners.forEach(l -> l.accept(withMessage));
    }

    @Override
    protected void refreshLoaded() {
        this.sendLoaded();
        this.loadedListeners.forEach(l -> l.accept(true));
    }

    public void logout() {
        this.session().logout();
        this.notifyLoggedOut();
    }

    protected void init() {
        super.init();
        this.sendInfo(this.info());
        this.user().ifPresent(user -> this.sendUser(this.userOf((User)user)));
        this.sendItems();
        this.sendNameSpaceList();
        this.notifyLoaded();
    }

    @Override
    protected Element element(String label) {
        Item item = this.item(label);
        return item != null ? item.element() : null;
    }

    @Override
    protected Record target(String label) {
        Item item = this.item(label);
        return item != null ? item.target() : null;
    }

    protected Item item(String label) {
        return this.items.stream().filter(i -> i.label().equals(label)).findFirst().orElse(null);
    }

    public abstract void selectItem(String var1);

    protected abstract void sendLoading();

    protected abstract void sendLoaded();

    protected abstract void sendUser(UserInfo var1);

    protected abstract void sendInfo(PlatformInfo var1);

    protected abstract void sendItems(List<Item> var1);

    protected abstract void notifyLoggedOut();

    protected abstract void refreshNameSpaces(List<NameSpace> var1);

    protected abstract void refreshSelectedNameSpace(NameSpace var1);

    protected io.intino.sumus.box.schemas.Item schemaItemOf(Item item) {
        io.intino.sumus.box.schemas.Item result = ItemBuilder.build(item.name(), item.label());
        List<ItemProperty> itemProperties = result.itemPropertyList();
        itemProperties.add(new ItemProperty().name("type").value(LayoutDisplay.typeOf(item.element())));
        itemProperties.add(new ItemProperty().name("group").value(item.group() != null ? item.group().label() : null));
        itemProperties.add(new ItemProperty().name("group_opened").value(item.group() != null ? String.valueOf(item.group().mode() == Group.Mode.Expanded) : null));
        return result;
    }

    private List<Item> itemOf(ElementOption option) {
        ElementRender render = this.renderOf(option);
        if (render == null) {
            return Collections.emptyList();
        }
        return this.itemsProviders.get(((Object)((Object)render)).getClass()).apply(render);
    }

    private ElementRender renderOf(ElementOption option) {
        if (option.i$(Option.class)) {
            return ((Option)option.a$(Option.class)).elementRender();
        }
        if (option.i$(Options.class)) {
            return ((Options)option.a$(Options.class)).elementRender();
        }
        return null;
    }

    private String labelOf(ElementRender render, Element element, Record record) {
        Node owner = render.core$().owner();
        if (owner.is(Option.class)) {
            return ((Option)owner.as(Option.class)).label();
        }
        if (owner.is(Group.class)) {
            return ((Option)owner.as(Option.class)).label();
        }
        if (owner.is(Options.class)) {
            return ((Options)owner.as(Options.class)).label(element, record);
        }
        return "no label";
    }

    private List<Item> items() {
        return this.optionList().map(this::itemOf).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Stream<ElementOption> optionList() {
        return this.platform().layout().elementOptionList().stream().map(v -> {
            if (v.i$(Group.class)) {
                return ((Group)v.a$(Group.class)).elementOptionList();
            }
            return Collections.singletonList(v);
        }).flatMap(Collection::stream);
    }

    private static String typeOf(Element element) {
        if (element == null) {
            return "";
        }
        if (element.i$(Panel.class)) {
            return "panel";
        }
        if (element.i$(EntityHolderCatalog.class)) {
            return "entity";
        }
        if (element.i$(EventHolderCatalog.class)) {
            return "event";
        }
        if (element.i$(ReportHolderCatalog.class)) {
            return "report";
        }
        return "";
    }

    private void sendItems() {
        this.items = this.items();
        this.sendItems(this.items);
    }

    private List<Item> panelItem(ElementRender r) {
        Panel panel = ((RenderPanel)r.a$(RenderPanel.class)).panel();
        return Collections.singletonList(this.itemOf(r, panel));
    }

    private List<Item> panelItems(ElementRender r) {
        List<Panel> panelList = ((RenderPanels)r.a$(RenderPanels.class)).source();
        return panelList.stream().map(c -> this.itemOf(r, (Element)((Object)c))).collect(Collectors.toList());
    }

    private List<Item> recordItem(ElementRender r) {
        RenderRecord recordViewCollection = (RenderRecord)r.a$(RenderRecord.class);
        Record record = recordViewCollection.record();
        return Collections.singletonList(this.itemOf(r, recordViewCollection.container(), record));
    }

    private List<Item> recordItems(ElementRender r) {
        RenderRecords recordViewCollection = (RenderRecords)r.a$(RenderRecords.class);
        List<Record> recordList = recordViewCollection.source();
        return recordList.stream().map(record -> this.itemOf(r, recordViewCollection.panel(), (Record)((Object)record))).collect(Collectors.toList());
    }

    private List<Item> catalogItem(ElementRender r) {
        Catalog catalog = ((RenderCatalog)r.a$(RenderCatalog.class)).catalog();
        return Collections.singletonList(this.itemOf(r, catalog));
    }

    private List<Item> catalogItems(ElementRender r) {
        RenderCatalogs render = (RenderCatalogs)r.a$(RenderCatalogs.class);
        return this.platform().catalogList().stream().filter(render::filter).map(c -> this.itemOf(r, (Element)((Object)c))).collect(Collectors.toList());
    }

    private List<Item> olapItems(ElementRender r) {
        RenderOlap render = (RenderOlap)r.a$(RenderOlap.class);
        return Collections.singletonList(this.itemOf(r, render.olap()));
    }

    private List<Item> moldItems(ElementRender r) {
        RenderMold render = (RenderMold)r.a$(RenderMold.class);
        return Collections.singletonList(this.itemOf(r, render.mold()));
    }

    private PlatformInfo info() {
        Settings settings = this.box.actionsConfiguration();
        return PlatformInfoBuilder.build(settings, this.box.configuration().platformConfiguration().authServiceUrl());
    }

    private UserInfo userOf(User user) {
        return new UserInfo().fullName(user.fullName()).photo(user.photo().toString());
    }

    private void notifyLoaded() {
        this.loadedListeners.forEach(l -> l.accept(true));
    }

    private void buildElementProviders() {
        this.itemsProviders.put(RenderPanel.class, this::panelItem);
        this.itemsProviders.put(RenderPanels.class, this::panelItems);
        this.itemsProviders.put(RenderRecord.class, this::recordItem);
        this.itemsProviders.put(RenderRecords.class, this::recordItems);
        this.itemsProviders.put(RenderCatalog.class, this::catalogItem);
        this.itemsProviders.put(RenderCatalogs.class, this::catalogItems);
        this.itemsProviders.put(RenderOlap.class, this::olapItems);
        this.itemsProviders.put(RenderMold.class, this::moldItems);
    }

    private Item itemOf(ElementRender render, Element element) {
        return this.itemOf(render, element, null);
    }

    private Item itemOf(final ElementRender render, final Element element, final Record target) {
        return new Item(){

            @Override
            public String name() {
                return target != null ? target.name$() : element.name$();
            }

            @Override
            public String label() {
                return LayoutDisplay.this.labelOf(render, element, target);
            }

            @Override
            public Group group() {
                return (Group)render.core$().ownerAs(Group.class);
            }

            @Override
            public Element element() {
                return element;
            }

            @Override
            public Record target() {
                return target;
            }
        };
    }

    private void sendNameSpaceList() {
        this.refreshNameSpaces(this.nameSpaceHandler().nameSpaces(this.username()));
        this.refreshSelectedNameSpace(this.nameSpaceHandler().selectedNameSpace(this.username()));
    }

    protected static interface Item {
        public String name();

        public String label();

        public Group group();

        public Element element();

        public Record target();
    }
}

