/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.TemporalCatalogDisplay;
import io.intino.sumus.box.displays.TimeRangeNavigatorDisplay;
import io.intino.sumus.box.displays.builders.CatalogBuilder;
import io.intino.sumus.box.displays.notifiers.EventCatalogDisplayNotifier;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.TimeScaleHandler;
import io.intino.sumus.queries.TemporalRecordQuery;
import io.intino.tara.magritte.Concept;
import java.time.Instant;
import java.util.List;

public class EventCatalogDisplay
extends TemporalCatalogDisplay<EventCatalogDisplayNotifier, TimeRangeNavigatorDisplay> {
    public EventCatalogDisplay(SumusBox box) {
        super(box, new TimeRangeNavigatorDisplay(box));
    }

    @Override
    public void clearFilter() {
        super.clearFilter();
    }

    @Override
    protected void refreshBreadcrumbs(String breadcrumbs) {
        ((EventCatalogDisplayNotifier)this.notifier).refreshBreadcrumbs(breadcrumbs);
    }

    @Override
    protected void createPanel(String item) {
        ((EventCatalogDisplayNotifier)this.notifier).createPanel(item);
    }

    @Override
    protected void showPanel() {
        ((EventCatalogDisplayNotifier)this.notifier).showPanel();
    }

    @Override
    protected void hidePanel() {
        ((EventCatalogDisplayNotifier)this.notifier).hidePanel();
    }

    @Override
    protected void sendCatalog() {
        ((EventCatalogDisplayNotifier)this.notifier).refreshCatalog(CatalogBuilder.build((Catalog)((Object)this.element()), this.manager, this.label(), this.embedded()));
    }

    @Override
    protected void showDialog() {
        ((EventCatalogDisplayNotifier)this.notifier).showDialog();
    }

    @Override
    protected void notifyFiltered(boolean value) {
        ((EventCatalogDisplayNotifier)this.notifier).refreshFiltered(value);
    }

    @Override
    public void selectGrouping(GroupingSelection value) {
        super.selectGrouping(value);
    }

    @Override
    protected int maxZoom() {
        return ((Catalog)((Object)this.element())).asEventHolder().maxZoom();
    }

    @Override
    protected void configureTimeScaleHandler(TimeScaleHandler timeScaleHandler, TimeRange range, List<TimeScale> scales) {
        timeScaleHandler.updateScale(scales.get(0));
    }

    @Override
    protected void configureNavigatorDisplay(TimeRangeNavigatorDisplay navigatorDisplay, TimeScaleHandler timeScaleHandler) {
        navigatorDisplay.onMove(this::refresh);
        navigatorDisplay.onFromChange(this::refresh);
        navigatorDisplay.onToChange(this::refresh);
        navigatorDisplay.onMoveNext(this::refresh);
        navigatorDisplay.onMovePrevious(this::refresh);
    }

    @Override
    protected Concept recordConcept() {
        return ((Catalog)((Object)this.element())).asEventHolder().event();
    }

    @Override
    protected void showTimeNavigator() {
        ((EventCatalogDisplayNotifier)this.notifier).showTimeRangeNavigator();
    }

    @Override
    protected void addTime(TemporalRecordQuery.Builder builder) {
        int offset = this.timezoneOffset();
        TimeRange range = this.timeScaleHandler().range();
        Instant newFrom = range.scale().normalise(range.from().plusSeconds(offset * 3600));
        Instant newTo = range.scale().nextTime(newFrom);
        while (!newTo.isAfter(range.to())) {
            newTo = range.scale().nextTime(newTo);
        }
        newTo = newTo.plusSeconds(offset * 3600).minusMillis(1L);
        builder.timeRange(new TimeRange(newFrom, newTo, range.scale()));
    }

    @Override
    protected <R extends Record> void filterTimezone(RecordList<R> recordList, TimeRange range) {
        Instant from = range.from().plusSeconds(this.timezoneOffset() * 3600);
        Instant to = range.to().plusSeconds(this.timezoneOffset() * 3600);
        recordList.filter(record -> {
            TemporalRecord temporalRecord = (TemporalRecord)record.a$(TemporalRecord.class);
            return temporalRecord.created().isAfter(from) && temporalRecord.created().isBefore(to);
        });
    }

    @Override
    protected TimeScaleHandler timeScaleHandler() {
        return ((TimeRangeNavigatorDisplay)this.child(TimeRangeNavigatorDisplay.class)).timeScaleHandler();
    }

    @Override
    protected void hideTimeNavigator() {
        ((EventCatalogDisplayNotifier)this.notifier).hideTimeRangeNavigator();
    }

    public void timezoneOffset(Integer value) {
        super.timezoneOffset(value);
    }

    @Override
    public void navigate(String key) {
        super.navigate(key);
    }
}

