/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.RecordList;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.builders.CatalogBuilder;
import io.intino.sumus.box.displays.notifiers.EntityCatalogDisplayNotifier;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.GroupingGroup;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Record;
import io.intino.sumus.queries.CatalogManager;
import io.intino.sumus.queries.EntityQuery;
import java.util.List;
import java.util.stream.Collectors;

public class EntityCatalogDisplay
extends CatalogDisplay<EntityCatalogDisplayNotifier>
implements CatalogViewDisplayProvider {
    public EntityCatalogDisplay(SumusBox box) {
        super(box);
    }

    @Override
    public void selectGrouping(GroupingSelection value) {
        super.selectGrouping(value);
    }

    @Override
    public void deleteGroupingGroup(GroupingGroup groupingGroup) {
        super.deleteGroupingGroup(groupingGroup);
    }

    @Override
    public void clearFilter() {
        super.clearFilter();
    }

    @Override
    protected void refreshBreadcrumbs(String breadcrumbs) {
        ((EntityCatalogDisplayNotifier)this.notifier).refreshBreadcrumbs(breadcrumbs);
    }

    @Override
    protected void createPanel(String item) {
        ((EntityCatalogDisplayNotifier)this.notifier).createPanel(item);
    }

    @Override
    protected void showPanel() {
        ((EntityCatalogDisplayNotifier)this.notifier).showPanel();
    }

    @Override
    protected void hidePanel() {
        ((EntityCatalogDisplayNotifier)this.notifier).hidePanel();
    }

    @Override
    protected void createCatalogManager() {
        RecordList<Entity> recordList = this.queryEngine().entities(this.query(null));
        this.manager = new CatalogManager(recordList.items().stream().map(i -> (Record)i.a$(Record.class)).collect(Collectors.toList()), this.categorizations(), this.keys());
    }

    @Override
    protected void sendCatalog() {
        ((EntityCatalogDisplayNotifier)this.notifier).refreshCatalog(CatalogBuilder.build((Catalog)((Object)this.element()), this.manager, this.label(), this.embedded()));
    }

    @Override
    protected void showDialog() {
        ((EntityCatalogDisplayNotifier)this.notifier).showDialog();
    }

    @Override
    protected void notifyFiltered(boolean value) {
        ((EntityCatalogDisplayNotifier)this.notifier).refreshFiltered(value);
    }

    @Override
    protected void selectNameSpace(NameSpace nameSpace) {
    }

    @Override
    protected <R extends Record> RecordList<R> records(String condition) {
        EntityQuery query = this.query(condition);
        RecordList<Entity> recordList = this.queryEngine().entities(query);
        this.applyFilter(recordList);
        return recordList;
    }

    @Override
    protected Record loadRecord(String id) {
        return this.queryEngine().entity(id, this.username());
    }

    @Override
    protected boolean canCreateClusters() {
        return ((Catalog)((Object)this.element())).analysis() != null && ((Catalog)((Object)this.element())).analysis().groupingList().size() > 0;
    }

    private EntityQuery query(String condition) {
        EntityQuery.Builder builder = new EntityQuery.Builder();
        builder.condition(condition);
        builder.filter(this.scope);
        return builder.build(((Catalog)((Object)this.element())).asEntityHolder().entity(), this.username());
    }

    @Override
    public Record rootRecord(List<Record> recordList) {
        return ((Catalog)((Object)this.element())).asEntityHolder().rootRecord(recordList, this.username());
    }

    @Override
    public Record defaultRecord(String name) {
        return ((Catalog)((Object)this.element())).asEntityHolder().defaultRecord(name, this.username());
    }

    @Override
    public void navigate(String key) {
        super.navigate(key);
    }
}

