/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.ElementDisplay;
import io.intino.sumus.box.displays.ElementDisplayManager;
import io.intino.sumus.box.displays.EntityCatalogDisplay;
import io.intino.sumus.box.displays.EventCatalogDisplay;
import io.intino.sumus.box.displays.PanelDisplay;
import io.intino.sumus.box.displays.ReportCatalogDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.entityholder.EntityHolderCatalog;
import io.intino.sumus.graph.eventholder.EventHolderCatalog;
import io.intino.sumus.graph.reportholder.ReportHolderCatalog;
import io.intino.sumus.helpers.NameSpaceHandler;
import io.intino.tara.magritte.Layer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class ElementRepositoryDisplay<DN extends DisplayNotifier>
extends SumusDisplay<DN>
implements ElementDisplayManager {
    private final NameSpaceHandler nameSpaceHandler;
    private Map<Class<? extends Layer>, Function<Element, ElementDisplay>> builders = new HashMap<Class<? extends Layer>, Function<Element, ElementDisplay>>();
    private Map<String, ElementDisplay> displayMap = new HashMap<String, ElementDisplay>();

    public ElementRepositoryDisplay(SumusBox box) {
        super(box);
        this.registerBuilders();
        this.nameSpaceHandler = new NameSpaceHandler(box.graph());
    }

    @Override
    public <E extends ElementDisplay> E openElement(String label) {
        Element element = this.element(label);
        Record target = this.target(label);
        E display = this.display(label);
        if (display != null) {
            ((ElementDisplay)display).clearFilter();
            this.refreshSelected(label);
            return display;
        }
        this.refreshLoading(true);
        display = this.addAndBuildDisplay(element, target, label);
        this.refreshLoaded();
        this.refreshSelected(label);
        return display;
    }

    @Override
    public <E extends ElementDisplay> E createElement(Element element, Record target) {
        E display = this.display(target.name$());
        if (display != null) {
            return display;
        }
        return this.buildDisplay(element, target, target.name$());
    }

    public void selectNameSpace(String key) {
        this.nameSpaceHandler.select(key);
    }

    @Override
    public <E extends ElementDisplay> E display(String label) {
        return (E)((ElementDisplay)this.displayMap.getOrDefault(label, null));
    }

    protected abstract void refreshSelected(String var1);

    protected abstract void refreshLoading(boolean var1);

    protected abstract void refreshLoaded();

    protected abstract Element element(String var1);

    protected abstract Record target(String var1);

    protected Class classFor(Element element) {
        if (element.i$(Catalog.class)) {
            return ((Object)((Object)((Catalog)element.a$(Catalog.class)).asHolder())).getClass();
        }
        return ((Object)((Object)((Panel)element.a$(Panel.class)))).getClass();
    }

    protected NameSpaceHandler nameSpaceHandler() {
        return this.nameSpaceHandler;
    }

    private void registerBuilders() {
        this.builders.put(Panel.class, this::buildPanelDisplay);
        this.builders.put(EntityHolderCatalog.class, this::buildEntityCatalogDisplay);
        this.builders.put(EventHolderCatalog.class, this::buildEventCatalogDisplay);
        this.builders.put(ReportHolderCatalog.class, this::buildReportCatalogDisplay);
    }

    private PanelDisplay buildPanelDisplay(Element component) {
        PanelDisplay display = new PanelDisplay(this.box);
        display.element((Element)component.a$(Panel.class));
        return display;
    }

    private CatalogDisplay buildEntityCatalogDisplay(Element component) {
        EntityCatalogDisplay display = new EntityCatalogDisplay(this.box);
        display.element((Element)component.a$(Catalog.class));
        return display;
    }

    private CatalogDisplay buildEventCatalogDisplay(Element component) {
        EventCatalogDisplay display = new EventCatalogDisplay(this.box);
        display.element((Element)component.a$(Catalog.class));
        return display;
    }

    private CatalogDisplay buildReportCatalogDisplay(Element component) {
        ReportCatalogDisplay display = new ReportCatalogDisplay(this.box);
        display.element((Element)component.a$(Catalog.class));
        return display;
    }

    private <E extends ElementDisplay> E addAndBuildDisplay(Element element, Record target, String label) {
        E display = this.buildDisplay(element, target, label);
        display.personifyOnce(label);
        return display;
    }

    private <E extends ElementDisplay> E buildDisplay(Element element, Record target, String label) {
        E display = this.buildDisplayFor(element, target, label);
        ((ElementDisplay)display).elementDisplayManager(this);
        this.add((Display)display);
        ((ElementDisplay)display).onLoading(value -> {
            if (((Boolean)value).booleanValue()) {
                this.refreshLoading(false);
            } else {
                this.refreshLoaded();
            }
        });
        return display;
    }

    private <E extends ElementDisplay> E buildDisplayFor(Element element, Record target, String label) {
        Class clazz = this.classFor(element);
        ElementDisplay display = this.builders.get(clazz).apply(element);
        display.nameSpaceHandler(this.nameSpaceHandler);
        display.label(label);
        display.element(element);
        display.target(target);
        this.displayMap.put(label, display);
        return (E)display;
    }
}

