/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import com.google.gson.Gson;
import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogDisplay;
import io.intino.sumus.box.displays.CatalogInstantBlock;
import io.intino.sumus.box.displays.DialogContainerDisplay;
import io.intino.sumus.box.displays.ElementDisplayManager;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.PanelDisplay;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.RecordItemBuilder;
import io.intino.sumus.box.schemas.ElementOperationParameters;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.box.schemas.SaveItemParameters;
import io.intino.sumus.graph.AbstractView;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.Toolbar;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.graph.functions.StampSaveEvent;
import io.intino.sumus.graph.functions.Tree;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.ElementHelper;
import io.intino.sumus.helpers.NameSpaceHandler;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ElementDisplay<E extends Element, DN extends DisplayNotifier>
extends SumusDisplay<DN>
implements RecordItemBuilder.RecordItemBuilderProvider {
    private String label;
    private E element;
    private Record target;
    private NameSpaceHandler nameSpaceHandler = null;
    private ElementDisplayManager elementDisplayManager = null;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private ElementViewDisplay currentView = null;
    private Function<Record, Boolean> recordFilter = null;
    private Boolean dirty = null;
    private boolean embedded = false;
    private ElementViewDisplay.OpenItemEvent openedItem = null;
    private TimeRange range;

    public ElementDisplay(SumusBox box) {
        super(box);
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public E element() {
        return this.element;
    }

    public void element(E element) {
        this.element = element;
    }

    public Record target() {
        return this.target;
    }

    public void target(Record target) {
        this.target = target;
    }

    public ElementDisplayManager elementDisplayManager() {
        return this.elementDisplayManager;
    }

    public void elementDisplayManager(ElementDisplayManager manager) {
        this.elementDisplayManager = manager;
    }

    public NameSpaceHandler nameSpaceHandler() {
        if (this.nameSpaceHandler == null) {
            this.nameSpaceHandler = new NameSpaceHandler(this.box.graph());
        }
        return this.nameSpaceHandler;
    }

    public NameSpace nameSpace() {
        return this.nameSpaceHandler().selectedNameSpace(this.username());
    }

    public TimeRange range() {
        return this.range;
    }

    public void range(TimeRange range) {
        this.range = range;
    }

    public void nameSpaceHandler(NameSpaceHandler nameSpaceHandler) {
        this.nameSpaceHandler = nameSpaceHandler;
        this.nameSpaceHandler.onSelect(this::selectNameSpace);
    }

    public boolean embedded() {
        return this.embedded;
    }

    public void embedded(boolean value) {
        this.embedded = value;
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void filter(Function<Record, Boolean> recordFilter) {
        this.recordFilter = recordFilter;
        this.dirty(true);
    }

    public void filterAndNotify(Function<Record, Boolean> recordFilter) {
        this.filter(recordFilter);
        this.notifyFiltered(recordFilter != null);
    }

    public void clearFilter() {
        boolean refresh = this.recordFilter != null;
        this.filterAndNotify(null);
        if (refresh) {
            this.refresh();
        }
    }

    @Override
    public List<Mold.Block> blocks() {
        return this.molds().stream().map(this::blocks).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Mold.Block> blocks(Mold mold) {
        return mold.blockList().stream().map(this::blocks).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Mold.Block> blocks(Mold.Block block) {
        ArrayList<Mold.Block> result = new ArrayList<Mold.Block>();
        result.add(block);
        block.blockList().forEach(child -> result.addAll(this.blocks((Mold.Block)((Object)child))));
        return result;
    }

    @Override
    public List<Mold.Block.Stamp> stamps() {
        return this.molds().stream().map(Mold::blockList).flatMap(Collection::stream).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Mold.Block.Stamp> stamps(Mold mold) {
        return mold.blockList().stream().map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Mold.Block.Stamp> stamps(Mold.Block block) {
        ArrayList<Mold.Block.Stamp> stamps = new ArrayList<Mold.Block.Stamp>();
        stamps.addAll(block.stampList());
        block.blockList().forEach(child -> stamps.addAll(this.stamps((Mold.Block)((Object)child))));
        return stamps;
    }

    public List<Mold.Block.Stamp> expandedStamps() {
        return this.molds().stream().map(Mold::blockList).flatMap(Collection::stream).filter(Mold.Block::isExpanded).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Mold.Block.Stamp> expandedStamps(Mold mold) {
        return mold.blockList().stream().filter(Mold.Block::isExpanded).map(this::stamps).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Mold.Block.Stamp stamp(Mold mold, String name) {
        return this.stamps(mold).stream().filter((? super T s) -> s.name$().equals(name)).findFirst().orElse(null);
    }

    public Mold.Block.Stamp stamp(String name) {
        return this.stamps().stream().filter((? super T s) -> s.name$().equals(name)).findFirst().orElse(null);
    }

    public StampDisplay display(String stamp) {
        return this.box.stampDisplayProvider() != null ? this.box.stampDisplayProvider().display(stamp) : null;
    }

    public void executeOperation(ElementOperationParameters params, List<Record> selection) {
        Toolbar.Operation operation = this.operationOf(params);
        this.executeOperation(operation, params.option(), selection);
    }

    public Resource downloadOperation(ElementOperationParameters params, List<Record> selection) {
        Toolbar.Operation operation = this.operationOf(params);
        return this.downloadOperation(operation, params, selection);
    }

    public void saveItem(SaveItemParameters params, Record record) {
        Mold.Block.Stamp stamp = this.stamp(params.stamp());
        if (!stamp.isEditable()) {
            return;
        }
        this.currentRecord(new String(Base64.getDecoder().decode(params.item())));
        StampSaveEvent.Refresh refresh = stamp.asEditable().onSave(record, params.value(), this.username());
        this.currentView().ifPresent(view -> {
            this.dirty(true);
            if (refresh == StampSaveEvent.Refresh.Record) {
                view.refresh(this.currentItem());
            } else if (refresh == StampSaveEvent.Refresh.Catalog) {
                view.refresh();
            }
        });
    }

    public Optional<ElementViewDisplay> currentView() {
        return Optional.ofNullable(this.currentView);
    }

    @Override
    public TimeScale scale() {
        return null;
    }

    public void refresh() {
        this.refreshView();
    }

    public void refreshView() {
        this.currentView().ifPresent(ElementViewDisplay::refresh);
    }

    public void refresh(Record ... records) {
        this.currentView().ifPresent(v -> v.refresh(ElementHelper.recordItems(records, this, this.baseAssetUrl())));
    }

    public boolean dirty() {
        return this.dirty == null || this.dirty != false;
    }

    public void dirty(boolean value) {
        this.dirty = value;
    }

    public void navigate(String key) {
        if (!key.equals("main")) {
            return;
        }
        this.hidePanel();
        this.refreshBreadcrumbs("");
    }

    public void selectInstant(CatalogInstantBlock block) {
        CatalogDisplay display = this.catalogDisplayOf(block);
        List<String> entities = block.entities();
        display.filterAndNotify(record -> entities.contains(((Record)((Object)((Object)record))).core$().id()));
        display.refreshViews();
    }

    private CatalogDisplay catalogDisplayOf(CatalogInstantBlock block) {
        if (!this.element.name$().equals(block.catalog()) && !((Element)((Object)this.element)).label().equals(block.catalog())) {
            return (CatalogDisplay)this.openElement(block.catalog());
        }
        CatalogDisplay display = (CatalogDisplay)this;
        List<AbstractView> views = display.views();
        Catalog.View view = views.stream().map(v -> (Catalog.View)((Object)((Object)v))).filter((? super T v) -> !v.i$(Catalog.OlapView.class)).findFirst().orElse(null);
        if (view != null) {
            display.selectView(view.name$());
        }
        return display;
    }

    protected void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }

    protected List<? extends AbstractView> views() {
        E element = this.element();
        if (element.i$(Catalog.class)) {
            Catalog catalog = (Catalog)element.a$(Catalog.class);
            return catalog.view() != null ? Collections.singletonList(catalog.view()) : catalog.views().viewList();
        }
        if (element.i$(Panel.class)) {
            Panel panel = (Panel)element.a$(Panel.class);
            return panel.view() != null ? Collections.singletonList(panel.view()) : panel.views().viewList();
        }
        return Collections.emptyList();
    }

    protected List<Mold> molds() {
        return this.views().stream().filter((? super T v) -> v.i$(Catalog.MoldView.class)).map(v -> ((Catalog.MoldView)v.a$(Catalog.MoldView.class)).mold()).collect(Collectors.toList());
    }

    protected void updateCurrentView(ElementViewDisplay display) {
        this.currentView = display;
        this.refreshView();
    }

    protected void createDialogContainer() {
        DialogContainerDisplay display = new DialogContainerDisplay(this.box);
        display.onDialogAssertion(modification -> this.currentView().ifPresent(view -> {
            this.dirty(true);
            if (modification.toLowerCase().equals("itemmodified")) {
                view.refresh(this.currentItem());
            } else if (modification.toLowerCase().equals("catalogmodified")) {
                view.refresh();
            }
        }));
        this.add(display);
        display.personifyOnce();
    }

    protected void openItem(ElementViewDisplay.OpenItemEvent event) {
        this.openedItem = event;
        this.showPanel();
        this.createPanel(event.item());
        PanelDisplay display = this.createPanelDisplay(event);
        this.add(display);
        display.personifyOnce(event.item());
        this.refreshBreadcrumbs(this.breadcrumbs(event));
    }

    protected void openItemDialog(ElementViewDisplay.OpenItemDialogEvent event) {
        this.currentRecord(new String(Base64.getDecoder().decode(event.item())));
        DialogContainerDisplay display = (DialogContainerDisplay)this.child(DialogContainerDisplay.class);
        display.dialogWidth(event.width());
        display.dialogHeight(event.height());
        display.dialogLocation(event.path());
        display.refresh();
        this.showDialog();
    }

    protected void executeItemTask(ElementViewDisplay.ExecuteItemTaskEvent event) {
        this.currentRecord(new String(Base64.getDecoder().decode(event.item())));
        Record record = this.currentRecord();
        ((Mold.Block.TaskOperation)event.stamp().a$(Mold.Block.TaskOperation.class)).task(record, this.username());
        this.dirty(true);
        this.refresh(this.currentRecord());
    }

    public <E extends ElementDisplay> E openElement(String label) {
        return this.elementDisplayManager.openElement(label);
    }

    public PanelDisplay createPanelDisplay(ElementViewDisplay.OpenItemEvent event) {
        PanelDisplay display = (PanelDisplay)this.elementDisplayManager.createElement(event.panel(), event.record());
        display.range(event.range());
        return display;
    }

    public Record record(String key) {
        return this.loadRecord(key);
    }

    protected abstract void showDialog();

    protected abstract void currentRecord(String var1);

    protected abstract Record currentRecord();

    protected abstract void notifyFiltered(boolean var1);

    protected abstract void selectNameSpace(NameSpace var1);

    protected abstract Record loadRecord(String var1);

    protected abstract void refreshBreadcrumbs(String var1);

    protected abstract void createPanel(String var1);

    protected abstract void showPanel();

    protected abstract void hidePanel();

    protected void applyFilter(RecordList recordList) {
        if (this.recordFilter == null) {
            return;
        }
        recordList.filter(this.recordFilter);
    }

    private RecordItem currentItem() {
        return ElementHelper.recordItem(this.currentRecord(), this, this.baseAssetUrl());
    }

    private Toolbar.Operation operationOf(ElementOperationParameters params) {
        Optional<Toolbar> toolbar = this.toolbar();
        if (!toolbar.isPresent()) {
            return null;
        }
        return toolbar.get().operationList().stream().filter((? super T op) -> op.name$().equals(params.operation())).findFirst().orElse(null);
    }

    private Optional<Toolbar> toolbar() {
        E element = this.element();
        if (element.i$(Catalog.class)) {
            return Optional.ofNullable(((Catalog)element.a$(Catalog.class)).toolbar());
        }
        if (element.i$(Panel.class)) {
            return Optional.ofNullable(((Panel)element.a$(Panel.class)).toolbar());
        }
        return Optional.empty();
    }

    private void executeOperation(Toolbar.Operation operation, String option, List<Record> selection) {
        if (operation.i$(Toolbar.OpenDialog.class)) {
            DialogContainerDisplay display = (DialogContainerDisplay)this.child(DialogContainerDisplay.class);
            Toolbar.OpenDialog openDialog = (Toolbar.OpenDialog)operation.a$(Toolbar.OpenDialog.class);
            display.dialogWidth(openDialog.width());
            display.dialogHeight(openDialog.height());
            display.dialogLocation(openDialog.path());
            display.refresh();
            this.showDialog();
        }
        if (operation.i$(Toolbar.Task.class)) {
            Toolbar.Task taskOperation = (Toolbar.Task)operation.a$(Toolbar.Task.class);
            taskOperation.execute((Element)this.element().a$(Catalog.class), option, this.username());
            if (taskOperation.refresh() == Toolbar.Task.Refresh.Catalog) {
                this.refresh();
            }
            return;
        }
        if (operation.i$(Toolbar.TaskSelection.class)) {
            Toolbar.TaskSelection taskSelectionOperation = (Toolbar.TaskSelection)operation.a$(Toolbar.TaskSelection.class);
            taskSelectionOperation.execute((Element)this.element().a$(Catalog.class), option, selection, this.username());
            if (taskSelectionOperation.refresh() == Toolbar.TaskSelection.Refresh.Catalog) {
                this.refresh();
            } else if (taskSelectionOperation.refresh() == Toolbar.TaskSelection.Refresh.Selection) {
                this.refresh(selection.toArray(new Record[selection.size()]));
            }
        }
    }

    private Resource downloadOperation(Toolbar.Operation operation, ElementOperationParameters params, List<Record> selection) {
        E element = this.element();
        if (operation.i$(Toolbar.Export.class)) {
            return ((Toolbar.Export)operation.a$(Toolbar.Export.class)).execute((Element)((Object)element), params.from(), params.to());
        }
        if (operation.i$(Toolbar.ExportSelection.class)) {
            return ((Toolbar.ExportSelection)operation.a$(Toolbar.ExportSelection.class)).execute((Element)((Object)element), params.from(), params.to(), selection);
        }
        if (operation.i$(Toolbar.Download.class)) {
            return ((Toolbar.Download)operation.a$(Toolbar.Download.class)).execute((Element)((Object)element), params.option());
        }
        if (operation.i$(Toolbar.DownloadSelection.class)) {
            return ((Toolbar.DownloadSelection)operation.a$(Toolbar.DownloadSelection.class)).execute((Element)((Object)element), params.option(), selection);
        }
        return null;
    }

    private String breadcrumbs(ElementViewDisplay.OpenItemEvent event) {
        Tree tree = event.breadcrumbs();
        if (tree == null) {
            tree = new Tree();
            Tree.TreeItem main = new Tree.TreeItem().name("main").label(this.label());
            if (this.openedItem != null) {
                main.add(new Tree.TreeItem().name(this.openedItem.record().name$()).label(this.openedItem.label()));
            }
            tree.add(main);
        }
        return new Gson().toJson((Object)tree);
    }
}

