/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.DialogBuilder;
import io.intino.sumus.box.displays.notifiers.DialogContainerDisplayNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class DialogContainerDisplay
extends SumusDisplay<DialogContainerDisplayNotifier> {
    private int width;
    private int height;
    private String location;
    private List<Consumer<String>> assertionListeners = new ArrayList<Consumer<String>>();

    public DialogContainerDisplay(SumusBox box) {
        super(box);
    }

    public void dialogWidth(int width) {
        this.width = width;
    }

    public void dialogHeight(int height) {
        this.height = height;
    }

    public void dialogLocation(String location) {
        this.location = location;
    }

    public void onDialogAssertion(Consumer<String> listener) {
        this.assertionListeners.add(listener);
    }

    public void refresh() {
        super.refresh();
        this.sendInfo();
    }

    private void sendInfo() {
        ((DialogContainerDisplayNotifier)this.notifier).refreshDialog(DialogBuilder.build(this.location, this.width, this.height));
    }

    public void dialogAssertionMade(String modification) {
        this.assertionListeners.forEach(l -> l.accept(modification));
    }
}

