/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.LayoutDisplay;
import io.intino.sumus.box.displays.MenuLayoutDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.TabLayoutDisplay;
import io.intino.sumus.box.displays.notifiers.DesktopDisplayNotifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class DesktopDisplay
extends SumusDisplay<DesktopDisplayNotifier> {
    private Map<Layout, Function<Layout, LayoutDisplay>> builders = new HashMap<Layout, Function<Layout, LayoutDisplay>>();

    public DesktopDisplay(SumusBox box) {
        super(box);
        this.registerBuilders();
    }

    protected void init() {
        super.init();
        Layout layout = this.platform().layout().isTab() ? Layout.Tab : Layout.Menu;
        this.add(this.builders.get((Object)layout).apply(layout));
    }

    private void add(LayoutDisplay display) {
        this.addListeners(display);
        this.addAndPersonify(display);
    }

    private void addListeners(LayoutDisplay display) {
        display.onLoading(withMessage -> this.refreshLoading((Boolean)withMessage));
        display.onLoaded(value -> this.refreshLoaded());
    }

    private void refreshLoading(boolean withMessage) {
        ((DesktopDisplayNotifier)this.notifier).loading(withMessage);
    }

    private void refreshLoaded() {
        ((DesktopDisplayNotifier)this.notifier).loaded();
    }

    private void registerBuilders() {
        this.builders.put(Layout.Menu, layout -> new MenuLayoutDisplay(this.box));
        this.builders.put(Layout.Tab, layout -> new TabLayoutDisplay(this.box));
    }

    private static enum Layout {
        Tab,
        Menu;

    }
}

