/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.exporters.Document;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogInstantBlock;
import io.intino.sumus.box.displays.ChartNavigatorDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.schemas.CatalogInstant;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.helpers.ChartSpecHandler;
import io.intino.sumus.helpers.TimeScaleHandler;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class ChartDisplay<DN extends DisplayNotifier, N extends ChartNavigatorDisplay>
extends SumusDisplay<DN> {
    private final N navigatorDisplay;
    private ChartSpec spec = null;
    private TimeScaleHandler timeScaleHandler;
    private ChartSpecHandler chartSpecHandler;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<Boolean>> showDialogListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<CatalogInstantBlock>> selectListeners = new ArrayList<Consumer<CatalogInstantBlock>>();
    private Olap.InstantFormatter formatter;
    private NameSpace nameSpace = null;

    public ChartDisplay(SumusBox box, N navigatorDisplay) {
        super(box);
        this.navigatorDisplay = navigatorDisplay;
    }

    public void onShowDialog(Consumer<Boolean> listener) {
        this.showDialogListeners.add(listener);
    }

    public void onSelect(Consumer<CatalogInstantBlock> listener) {
        this.selectListeners.add(listener);
    }

    public void nameSpace(NameSpace nameSpace) {
        this.nameSpace = nameSpace;
    }

    public N navigatorDisplay() {
        return this.navigatorDisplay;
    }

    public void timeScaleHandler(TimeScaleHandler timeScaleHandler) {
        this.timeScaleHandler = timeScaleHandler;
    }

    public TimeScaleHandler timeScaleHandler() {
        return this.timeScaleHandler;
    }

    public void chartSpecHandler(ChartSpecHandler chartSpecHandler) {
        this.chartSpecHandler = chartSpecHandler;
        this.spec = this.chartSpecHandler().specification();
    }

    public ChartSpecHandler chartSpecHandler() {
        return this.chartSpecHandler;
    }

    public List<Categorization> categorizations() {
        return this.chartSpecHandler.olapCategorizations();
    }

    public List<TemporalCategorization> temporalCategorizations() {
        return this.chartSpecHandler.olapTemporalCategorizations();
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void instantFormatter(Olap.InstantFormatter formatter) {
        this.formatter = formatter;
    }

    public ChartSpec specification() {
        return this.spec;
    }

    public void specification(ChartSpec spec) {
        this.spec = spec;
        this.update();
    }

    public abstract boolean isValidSpecification(ChartSpec var1);

    public abstract void addNavigatorListeners(N var1);

    public abstract boolean allowMultipleTickets();

    public abstract boolean allowDrill();

    public abstract Document export(Instant var1, Instant var2);

    public abstract boolean isShowingEvents();

    public abstract boolean allowTemporalFiltering();

    public abstract Categorization byCategorization();

    protected void init() {
        super.init();
        this.configureNavigatorDisplay();
    }

    protected abstract void update();

    protected NameSpace nameSpace() {
        return this.nameSpace;
    }

    protected List<TimeScale> scales() {
        return this.timeScaleHandler().availableScales();
    }

    protected Olap.InstantFormatter instantFormatter() {
        return this.formatter;
    }

    protected void notifyLoading(boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    protected void configureNavigatorDisplay() {
        ((ChartNavigatorDisplay)((Object)this.navigatorDisplay)).timeScaleHandler(this.timeScaleHandler());
        this.addNavigatorListeners(this.navigatorDisplay);
        this.add((Display)this.navigatorDisplay);
        this.navigatorDisplay.personify();
    }

    protected Categorization categorizationOf(String key) {
        return this.allCategorizations().stream().filter(c -> c.name$().equals(key) || c.label().equals(key)).findFirst().orElse(null);
    }

    protected List<Categorization> allCategorizations() {
        ArrayList<Categorization> result = new ArrayList<Categorization>();
        result.addAll(this.categorizations());
        result.addAll(this.temporalCategorizations());
        return result;
    }

    protected void notifySelectInstant(final CatalogInstant instant, final List<String> entities) {
        this.selectListeners.forEach(l -> l.accept(new CatalogInstantBlock(){

            @Override
            public String catalog() {
                return instant.catalog();
            }

            @Override
            public Instant instant() {
                return instant.value();
            }

            @Override
            public List<String> entities() {
                return entities;
            }
        }));
    }

    public void showDialog() {
        this.showDialogListeners.forEach(l -> l.accept(true));
    }
}

