/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.Category;
import io.intino.sumus.analytics.viewmodels.CategoryView;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.CategorizationViewBuilder;
import io.intino.sumus.box.displays.builders.CategoryViewBuilder;
import io.intino.sumus.box.displays.notifiers.CategorizationDisplayNotifier;
import io.intino.sumus.box.schemas.CategorizationToggleDialog;
import io.intino.sumus.graph.Categorization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class CategorizationDisplay
extends SumusDisplay<CategorizationDisplayNotifier> {
    private Categorization categorization;
    private final List<Consumer<List<Category>>> selectListeners = new ArrayList<Consumer<List<Category>>>();
    private final List<Category> categories = new ArrayList<Category>();

    public CategorizationDisplay(SumusBox box) {
        super(box);
    }

    public void categorization(Categorization categorization) {
        this.categorization = categorization;
    }

    public Categorization categorization() {
        return this.categorization;
    }

    public void toggle(CategorizationToggleDialog dialog) {
        this.select(dialog.categories());
    }

    public void onSelect(Consumer<List<Category>> consumer) {
        this.selectListeners.add(consumer);
        this.children(CategorizationDisplay.class).forEach(d -> d.onSelect(consumer));
    }

    public Drill asDrill() {
        return this.categories.size() > 0 ? new Drill(this.categorization, this.categories) : null;
    }

    public boolean hasFilterCondition() {
        return this.categories.size() > 0;
    }

    public FilterCondition asFilterCondition() {
        return new FilterCondition(this.categorization, this.categories);
    }

    public void toggle(Category category) {
        if (this.categories.contains(category)) {
            this.categories.remove(category);
        } else {
            this.categories.add(category);
        }
        this.refreshSelected();
        this.notifySelection();
    }

    public void select(String[] categories) {
        this.select(Arrays.asList(categories));
    }

    public void select(List<String> categoryList) {
        this.categories.clear();
        List<Category> calculate = this.categorization.calculate(this.keys());
        categoryList.forEach(key -> {
            List foundCategories = calculate.stream().filter(c -> c.name().equals(key) || c.label().equals(key)).collect(Collectors.toList());
            if (foundCategories.size() > 0) {
                this.categories.add((Category)foundCategories.get(0));
            }
        });
        this.refreshSelected();
        this.notifySelection();
    }

    public void selectAll() {
        this.categories.clear();
        this.categories.addAll(this.categorization.calculate(this.keys()));
        this.refreshSelected();
        this.notifySelection();
    }

    public void selectNone() {
        this.categories.clear();
        this.refreshSelected();
        this.notifySelection();
    }

    public void maxSelection(int count) {
        ((CategorizationDisplayNotifier)this.notifier).refreshMaxSelection(count);
    }

    public void refresh() {
        super.refresh();
        ((CategorizationDisplayNotifier)this.notifier).refreshCategorization(CategorizationViewBuilder.build(io.intino.sumus.analytics.viewmodels.CategorizationViewBuilder.build(this.categorization, this.keys())));
    }

    private void notifySelection() {
        this.selectListeners.forEach(c -> c.accept(this.categories));
    }

    private void refreshSelected() {
        ((CategorizationDisplayNotifier)this.notifier).refreshSelected(CategoryViewBuilder.buildList(this.categories.stream().map(CategoryView::new).collect(Collectors.toList())));
    }
}

