/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogListViewDisplay;
import io.intino.sumus.box.displays.CatalogMagazineViewDisplay;
import io.intino.sumus.box.displays.CatalogMapViewDisplay;
import io.intino.sumus.box.displays.CatalogOlapViewDisplay;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.notifiers.CatalogViewListDisplayNotifier;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Cluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class CatalogViewListDisplay
extends SumusDisplay<CatalogViewListDisplayNotifier> {
    private List<Consumer<CatalogViewDisplay>> selectListeners = new ArrayList<Consumer<CatalogViewDisplay>>();
    private Map<String, Function<ElementView, ? extends Display>> builders = new HashMap<String, Function<ElementView, ? extends Display>>();
    private List<ElementView> viewList;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<Consumer<ElementViewDisplay.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemEvent>>();
    private List<Consumer<ElementViewDisplay.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemDialogEvent>>();
    private List<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>>();
    private List<Consumer<Cluster>> createClusterListeners = new ArrayList<Consumer<Cluster>>();
    private Map<String, CatalogViewDisplay> viewDisplayMap = new HashMap<String, CatalogViewDisplay>();

    public CatalogViewListDisplay(SumusBox box) {
        super(box);
        this.registerBuilders();
    }

    public void recordProvider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    public void viewList(List<ElementView> viewList) {
        this.viewList = viewList;
    }

    public void onSelectView(Consumer<CatalogViewDisplay> listener) {
        this.selectListeners.add(listener);
    }

    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    public void onCreateCluster(Consumer<Cluster> listener) {
        this.createClusterListeners.add(listener);
    }

    public void onOpenItem(Consumer<ElementViewDisplay.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    public void onOpenItemDialog(Consumer<ElementViewDisplay.OpenItemDialogEvent> listener) {
        this.openItemDialogListeners.add(listener);
    }

    public void onExecuteItemTask(Consumer<ElementViewDisplay.ExecuteItemTaskEvent> listener) {
        this.executeItemTaskListeners.add(listener);
    }

    public List<CatalogViewDisplay> viewList() {
        return new ArrayList<CatalogViewDisplay>(this.viewDisplayMap.values());
    }

    private void registerBuilders() {
        this.builders.put(Catalog.MagazineView.class.getSimpleName(), this::buildMagazineViewDisplay);
        this.builders.put(Catalog.ListView.class.getSimpleName(), this::buildListViewDisplay);
        this.builders.put(Catalog.GridView.class.getSimpleName(), this::buildListViewDisplay);
        this.builders.put(Catalog.MapView.class.getSimpleName(), this::buildMapViewDisplay);
        this.builders.put(Catalog.OlapView.class.getSimpleName(), this::buildOlapViewDisplay);
    }

    public void selectView(String name) {
        CatalogViewDisplay display = this.display(name);
        ((CatalogViewListDisplayNotifier)this.notifier).refreshSelectedView(name);
        this.selectListeners.forEach(l -> l.accept(display));
    }

    public void refresh() {
        this.viewDisplayMap.values().forEach(ElementViewDisplay::refresh);
    }

    protected void init() {
        super.init();
        this.sendTarget();
        this.sendViewList();
        if (this.viewList.size() > 0) {
            this.selectView(this.viewList.get(0).name());
        }
    }

    private CatalogViewDisplay display(String name) {
        if (!this.viewDisplayMap.containsKey(name)) {
            this.buildViewDisplay(name);
        }
        return this.viewDisplayMap.get(name);
    }

    private void buildViewDisplay(String name) {
        ElementView view = this.viewList.stream().filter(v -> v.name().equals(name)).findFirst().orElse(null);
        this.builders.get(view.type()).apply(view);
    }

    private void sendTarget() {
        if (this.provider.target() == null) {
            return;
        }
        ((CatalogViewListDisplayNotifier)this.notifier).refreshTarget(this.provider.target().name$());
    }

    private void sendViewList() {
        ((CatalogViewListDisplayNotifier)this.notifier).refreshViewList(ItemBuilder.buildCatalogViewList(this.viewList));
    }

    private CatalogMagazineViewDisplay buildMagazineViewDisplay(ElementView view) {
        CatalogMagazineViewDisplay display = new CatalogMagazineViewDisplay(this.box);
        this.registerViewDisplay(display, view);
        this.add(display);
        display.personifyOnce(this.idOf(view));
        return display;
    }

    private CatalogListViewDisplay buildListViewDisplay(ElementView view) {
        CatalogListViewDisplay display = new CatalogListViewDisplay(this.box);
        this.registerViewDisplay(display, view);
        this.add((Display)display);
        display.personifyOnce(this.idOf(view));
        return display;
    }

    private CatalogMapViewDisplay buildMapViewDisplay(ElementView view) {
        CatalogMapViewDisplay display = new CatalogMapViewDisplay(this.box);
        this.registerViewDisplay(display, view);
        this.add((Display)display);
        display.personifyOnce(this.idOf(view));
        return display;
    }

    private CatalogOlapViewDisplay buildOlapViewDisplay(ElementView view) {
        CatalogOlapViewDisplay display = new CatalogOlapViewDisplay(this.box);
        this.registerViewDisplay(display, view);
        this.add(display);
        display.personifyOnce(this.idOf(view));
        return display;
    }

    private void registerViewDisplay(CatalogViewDisplay display, ElementView view) {
        display.provider(this.provider);
        display.onOpenItem(this::openItem);
        display.onOpenItemDialog(this::openItemDialog);
        display.onExecuteItemTask(this::executeTask);
        display.onCreateCluster(this::notifyCreateCluster);
        display.view(view);
        display.onLoading(this::notifyLoading);
        this.viewDisplayMap.put(view.name(), display);
    }

    private void openItem(ElementViewDisplay.OpenItemEvent parameters) {
        this.openItemListeners.forEach(l -> l.accept(parameters));
    }

    private void openItemDialog(ElementViewDisplay.OpenItemDialogEvent event) {
        this.openItemDialogListeners.forEach(l -> l.accept(event));
    }

    private void executeTask(ElementViewDisplay.ExecuteItemTaskEvent event) {
        this.executeItemTaskListeners.forEach(l -> l.accept(event));
    }

    private void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }

    private void notifyCreateCluster(Cluster cluster) {
        this.createClusterListeners.forEach(l -> l.accept(cluster));
    }

    private String idOf(ElementView view) {
        return (this.provider.target() != null ? this.provider.target().name$() : "") + view.name();
    }
}

