/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogInstantBlock;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.OlapDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.notifiers.CatalogOlapViewDisplayNotifier;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Olap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class CatalogOlapViewDisplay
extends SumusDisplay<CatalogOlapViewDisplayNotifier>
implements CatalogViewDisplay {
    private ElementView<Catalog> view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();

    public CatalogOlapViewDisplay(SumusBox box) {
        super(box);
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenItemDialog(Consumer<ElementViewDisplay.OpenItemDialogEvent> location) {
    }

    @Override
    public void onExecuteItemTask(Consumer<ElementViewDisplay.ExecuteItemTaskEvent> params) {
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
    }

    @Override
    public void onOpenItem(Consumer<ElementViewDisplay.OpenItemEvent> listener) {
    }

    @Override
    public void reset() {
    }

    @Override
    public ElementView view() {
        return this.view;
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public void refresh() {
        super.refresh();
        ((OlapDisplay)this.child(OlapDisplay.class)).refresh();
    }

    protected void init() {
        super.init();
        this.buildOlapDisplay();
    }

    private void buildOlapDisplay() {
        OlapDisplay display = new OlapDisplay(this.box);
        display.nameSpaceHandler(this.provider.nameSpaceHandler());
        display.olap(this.olap(this.view.option()));
        display.onLoading(this::notifyLoading);
        display.onSelect(this::selectInstant);
        display.context(this.provider.elementType());
        this.add(display);
        display.personifyOnce();
    }

    private void selectInstant(CatalogInstantBlock block) {
        this.provider.selectInstant(block);
    }

    private Olap olap(String option) {
        return this.box.graph().olapList().stream().filter(o -> o.name$().equals(option) || o.label().equals(option)).findFirst().orElse(null);
    }

    private void notifyLoading(Boolean loading) {
        this.loadingListeners.forEach(l -> l.accept(loading));
    }

    @Override
    public void refresh(RecordItem ... items) {
    }
}

