/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.PageDisplay;
import io.intino.konos.server.activity.spark.ActivityFile;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.builders.ElementViewBuilder;
import io.intino.sumus.box.displays.builders.RecordItemBuilder;
import io.intino.sumus.box.displays.notifiers.CatalogMapViewDisplayNotifier;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.Bounds;
import io.intino.sumus.box.schemas.DownloadItemParameters;
import io.intino.sumus.box.schemas.ElementOperationParameters;
import io.intino.sumus.box.schemas.ExecuteItemTaskParameters;
import io.intino.sumus.box.schemas.OpenItemDialogParameters;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.helpers.Asset;
import io.intino.sumus.helpers.ElementHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class CatalogMapViewDisplay
extends PageDisplay<CatalogMapViewDisplayNotifier>
implements CatalogViewDisplay {
    private ElementView view;
    private CatalogViewDisplayProvider provider;
    private SumusBox box;
    private List<Consumer<ElementViewDisplay.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemDialogEvent>>();
    private List<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>>();
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();

    public CatalogMapViewDisplay(SumusBox box) {
        this.box = box;
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenItemDialog(Consumer<ElementViewDisplay.OpenItemDialogEvent> listener) {
        this.openItemDialogListeners.add(listener);
    }

    @Override
    public void onExecuteItemTask(Consumer<ElementViewDisplay.ExecuteItemTaskEvent> listener) {
        this.executeItemTaskListeners.add(listener);
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
    }

    @Override
    public void onOpenItem(Consumer<ElementViewDisplay.OpenItemEvent> listener) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public ElementView view() {
        return this.view;
    }

    public int countItems() {
        return this.provider.countRecords(null);
    }

    public void page(Integer value) {
        super.page(value.intValue());
    }

    public void location(Bounds value) {
    }

    protected void init() {
        super.init();
        this.sendView();
    }

    @Override
    public void refresh() {
        this.notifyLoading(true);
        super.refresh();
        this.notifyLoading(false);
    }

    protected void sendItems(int start, int limit) {
        ((CatalogMapViewDisplayNotifier)this.notifier).refresh(RecordItemBuilder.buildList(this.provider.records(start, limit, null), ElementHelper.recordItemDisplayProvider(this.provider, this.view), Asset.baseAssetUrl(this.session())));
    }

    protected void sendClear() {
        ((CatalogMapViewDisplayNotifier)this.notifier).clear();
    }

    protected void sendPageSize(int pageSize) {
        ((CatalogMapViewDisplayNotifier)this.notifier).refreshPageSize(pageSize);
    }

    protected void sendCount(int count) {
        ((CatalogMapViewDisplayNotifier)this.notifier).refreshCount(count);
    }

    private void sendView() {
        ((CatalogMapViewDisplayNotifier)this.notifier).refreshView(ElementViewBuilder.build(this.view));
    }

    public void openItemDialogOperation(OpenItemDialogParameters params) {
        this.openItemDialogListeners.forEach(l -> l.accept(ElementHelper.openItemDialogEvent(params.item(), this.provider.stamp(this.view.mold(), params.stamp()))));
    }

    public void executeItemTaskOperation(ExecuteItemTaskParameters params) {
        this.executeItemTaskListeners.forEach(l -> l.accept(ElementHelper.executeItemTaskEvent(params.item(), this.provider.stamp(this.view.mold(), params.stamp()))));
    }

    @Override
    public void refresh(RecordItem ... items) {
        Stream.of(items).forEach(item -> ((CatalogMapViewDisplayNotifier)this.notifier).refreshItem((RecordItem)item));
    }

    private void notifyLoading(boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    public ActivityFile downloadItemOperation(DownloadItemParameters value) {
        return null;
    }

    public void executeOperation(ElementOperationParameters value) {
        this.provider.executeOperation(value, Collections.emptyList());
    }

    public ActivityFile downloadOperation(ElementOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value, Collections.emptyList());
        return new ActivityFile(){

            public String label() {
                return resource.label();
            }

            public InputStream content() {
                return resource.content();
            }
        };
    }
}

