/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.spark.ActivityFile;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.RecordDisplay;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.notifiers.CatalogMagazineViewDisplayNotifier;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.ElementOperationParameters;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.helpers.ElementHelper;
import io.intino.tara.magritte.Predicate;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class CatalogMagazineViewDisplay
extends SumusDisplay<CatalogMagazineViewDisplayNotifier>
implements CatalogViewDisplay {
    private ElementView view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<ElementViewDisplay.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemDialogEvent>>();
    private List<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>>();
    private Record record = null;
    private String condition = null;
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private String currentRecord = null;

    public CatalogMagazineViewDisplay(SumusBox box) {
        super(box);
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    @Override
    public void onOpenItemDialog(Consumer<ElementViewDisplay.OpenItemDialogEvent> parameters) {
        this.openItemDialogListeners.add(parameters);
    }

    @Override
    public void onExecuteItemTask(Consumer<ElementViewDisplay.ExecuteItemTaskEvent> parameters) {
        this.executeItemTaskListeners.add(parameters);
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
    }

    @Override
    public void onOpenItem(Consumer<ElementViewDisplay.OpenItemEvent> listener) {
    }

    @Override
    public void reset() {
        this.currentRecord = null;
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public ElementView view() {
        return this.view;
    }

    @Override
    public void refresh(RecordItem ... items) {
        if (items.length <= 0) {
            return;
        }
        ((RecordDisplay)this.child(RecordDisplay.class)).refresh(items[0]);
    }

    protected void init() {
        super.init();
        this.createRecordDisplay();
    }

    private void createRecordDisplay() {
        RecordDisplay display = new RecordDisplay(this.box);
        display.emptyMessage(this.view.emptyMessage());
        display.mold(this.view.mold());
        display.context(this.provider.element());
        display.record(null);
        display.mode("magazine");
        display.provider(ElementHelper.recordDisplayProvider(this.provider, this.view));
        display.onOpenItem(this::selectRecord);
        display.onOpenItemDialog(this::openItemDialogOperation);
        display.onExecuteItemTask(this::executeItemTaskOperation);
        this.add(display);
        display.personifyOnce();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.notifyLoading(true);
        this.loadRecord();
        if (this.record == null) {
            return;
        }
        RecordDisplay recordDisplay = (RecordDisplay)this.child(RecordDisplay.class);
        recordDisplay.record(this.record);
        recordDisplay.refresh();
        this.notifyLoading(false);
    }

    public void filter(String value) {
        this.condition = value;
        this.loadRecord();
        this.refresh();
    }

    public void selectRecord(ElementViewDisplay.OpenItemEvent params) {
        this.currentRecord = params.item();
        this.refresh();
    }

    private void loadRecord() {
        int count = this.provider.countRecords(this.condition);
        this.record = this.currentRecord != null ? this.provider.record(this.nameOf(this.currentRecord)) : this.provider.rootRecord(this.provider.records(0, count, this.condition));
        this.currentRecord = this.record != null ? this.record.core$().id() : this.currentRecord;
        this.record = this.record != null ? this.record : this.provider.defaultRecord(this.nameOf(this.currentRecord));
    }

    private String nameOf(String currentRecord) {
        if (currentRecord == null) {
            return null;
        }
        return Predicate.nameOf((String)currentRecord);
    }

    private void notifyLoading(boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    public void openItemDialogOperation(ElementViewDisplay.OpenItemDialogEvent event) {
        this.openItemDialogListeners.forEach(l -> l.accept(event));
    }

    public void executeItemTaskOperation(ElementViewDisplay.ExecuteItemTaskEvent event) {
        this.executeItemTaskListeners.forEach(l -> l.accept(event));
    }

    public void executeOperation(ElementOperationParameters value) {
        this.provider.executeOperation(value, Collections.singletonList(this.record));
    }

    public ActivityFile downloadOperation(ElementOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value, Collections.singletonList(this.record));
        return new ActivityFile(){

            public String label() {
                return resource.label();
            }

            public InputStream content() {
                return resource.content();
            }
        };
    }
}

