/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.displays.PageDisplay;
import io.intino.konos.server.activity.services.push.User;
import io.intino.konos.server.activity.spark.ActivityFile;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.displays.builders.CatalogSortingBuilder;
import io.intino.sumus.box.displays.builders.ElementViewBuilder;
import io.intino.sumus.box.displays.builders.PictureDataBuilder;
import io.intino.sumus.box.displays.builders.RecordItemBuilder;
import io.intino.sumus.box.displays.notifiers.CatalogListViewDisplayNotifier;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.ClusterGroup;
import io.intino.sumus.box.schemas.DownloadItemParameters;
import io.intino.sumus.box.schemas.ElementOperationParameters;
import io.intino.sumus.box.schemas.ExecuteItemTaskParameters;
import io.intino.sumus.box.schemas.OpenItemDialogParameters;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.box.schemas.SaveItemParameters;
import io.intino.sumus.box.schemas.Sorting;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.OnClickRecord;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.graph.functions.Tree;
import io.intino.sumus.helpers.Asset;
import io.intino.sumus.helpers.ClusterHelper;
import io.intino.sumus.helpers.ElementHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spark.utils.IOUtils;

public class CatalogListViewDisplay
extends PageDisplay<CatalogListViewDisplayNotifier>
implements CatalogViewDisplay {
    private SumusBox box;
    private CatalogViewDisplayProvider.Sorting sorting;
    private ElementView<Catalog> view;
    private CatalogViewDisplayProvider provider;
    private List<Consumer<ElementViewDisplay.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemEvent>>();
    private List<Consumer<ElementViewDisplay.OpenItemDialogEvent>> openItemDialogListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemDialogEvent>>();
    private List<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>> executeItemTaskListeners = new ArrayList<Consumer<ElementViewDisplay.ExecuteItemTaskEvent>>();
    private List<Consumer<Cluster>> createClusterListeners = new ArrayList<Consumer<Cluster>>();
    private String condition = null;
    private Map<String, List<StampDisplay>> recordDisplaysMap = new HashMap<String, List<StampDisplay>>();
    private List<Consumer<Boolean>> loadingListeners = new ArrayList<Consumer<Boolean>>();
    private List<String> lastSelection = new ArrayList<String>();

    public CatalogListViewDisplay(SumusBox box) {
        this.box = box;
    }

    @Override
    public void view(ElementView view) {
        this.view = view;
    }

    @Override
    public void provider(CatalogViewDisplayProvider provider) {
        this.provider = provider;
    }

    public void selectSorting(Sorting sorting) {
        this.sorting = this.sortingOf(sorting);
        this.sendSelectedSorting();
        this.sendClear();
        this.page(0);
    }

    public int countItems() {
        return this.provider.countRecords(this.condition);
    }

    public void page(Integer value) {
        super.page(value.intValue());
    }

    @Override
    public void onOpenItem(Consumer<ElementViewDisplay.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    @Override
    public void onOpenItemDialog(Consumer<ElementViewDisplay.OpenItemDialogEvent> listener) {
        this.openItemDialogListeners.add(listener);
    }

    @Override
    public void onExecuteItemTask(Consumer<ElementViewDisplay.ExecuteItemTaskEvent> listener) {
        this.executeItemTaskListeners.add(listener);
    }

    @Override
    public void onCreateCluster(Consumer<Cluster> listener) {
        this.createClusterListeners.add(listener);
    }

    @Override
    public void reset() {
    }

    @Override
    public void onLoading(Consumer<Boolean> listener) {
        this.loadingListeners.add(listener);
    }

    @Override
    public ElementView view() {
        return this.view;
    }

    public void filter(String value) {
        this.condition = value;
        this.refresh();
    }

    @Override
    public void refresh(RecordItem ... items) {
        Stream.of(items).forEach(this::refresh);
    }

    public void selectItems(String[] records) {
        ArrayList<String> newRecords = new ArrayList<String>(Arrays.asList(records));
        newRecords.removeAll(this.lastSelection);
        newRecords.forEach(record -> {
            if (!this.recordDisplaysMap.containsKey(record)) {
                this.renderDisplays((String)record);
            }
            this.renderExpandedPictures((String)record);
        });
        this.lastSelection = new ArrayList<String>(Arrays.asList(records));
    }

    public void openItem(String value) {
        if (this.view.onClickRecordEvent() == null) {
            if (this.provider.expandedStamps(this.view.mold()).size() > 0) {
                ((CatalogListViewDisplayNotifier)this.notifier).refreshSelection(this.lastSelection.contains(value) ? Collections.emptyList() : Collections.singletonList(value));
            }
            return;
        }
        if (this.view.onClickRecordEvent().openPanel() != null) {
            this.notifyOpenItem(value);
        } else if (this.view.onClickRecordEvent().openDialog() != null) {
            this.notifyOpenDialog(value);
        }
    }

    private void notifyOpenItem(final String item) {
        this.openItemListeners.forEach(l -> l.accept(new ElementViewDisplay.OpenItemEvent(){

            @Override
            public String item() {
                return item;
            }

            @Override
            public String label() {
                Optional<Mold.Block.Stamp> titleStamp = CatalogListViewDisplay.this.provider.stamps(CatalogListViewDisplay.this.view.mold()).stream().filter(s -> s.i$(Mold.Block.Title.class)).findAny();
                return titleStamp.isPresent() ? ((Mold.Block.Title)titleStamp.get().a$(Mold.Block.Title.class)).title(this.record()) : this.record().name$();
            }

            @Override
            public Record record() {
                return CatalogListViewDisplay.this.provider.record(new String(Base64.getDecoder().decode(item)));
            }

            @Override
            public Panel panel() {
                return CatalogListViewDisplay.this.view.onClickRecordEvent().openPanel().panel();
            }

            @Override
            public NameSpace nameSpace() {
                Optional<User> user = CatalogListViewDisplay.this.provider.user();
                return CatalogListViewDisplay.this.provider.nameSpaceHandler().selectedNameSpace(user.isPresent() ? user.get().username() : null);
            }

            @Override
            public TimeRange range() {
                return CatalogListViewDisplay.this.provider.range();
            }

            @Override
            public Tree breadcrumbs() {
                Optional<User> user = CatalogListViewDisplay.this.provider.user();
                OnClickRecord.OpenPanel openPanel = CatalogListViewDisplay.this.view.onClickRecordEvent().openPanel();
                return openPanel != null ? openPanel.breadcrumbs(this.record(), user.isPresent() ? user.get().username() : null) : null;
            }
        }));
    }

    private void notifyOpenDialog(final String item) {
        this.openItemDialogListeners.forEach(l -> l.accept(new ElementViewDisplay.OpenItemDialogEvent(){

            @Override
            public String item() {
                return item;
            }

            @Override
            public String path() {
                return CatalogListViewDisplay.this.view.onClickRecordEvent().openDialog().path(item);
            }

            @Override
            public int width() {
                return CatalogListViewDisplay.this.view.onClickRecordEvent().openDialog().width();
            }

            @Override
            public int height() {
                return CatalogListViewDisplay.this.view.onClickRecordEvent().openDialog().height();
            }
        }));
    }

    public void renderExpandedPictures() {
        this.lastSelection.forEach(this::renderExpandedPictures);
    }

    private void renderDisplays(String item) {
        Map<Mold.Block.Display, StampDisplay> displays = this.displays(item);
        displays.forEach((stamp, display) -> {
            this.add((Display)display);
            display.personify(item + stamp.name$());
            display.refresh();
        });
        this.recordDisplaysMap.put(item, displays.values().stream().collect(Collectors.toList()));
    }

    private void renderExpandedPictures(String item) {
        this.refreshPictures(item, this.expandedPictures(item));
    }

    private void refreshPictures(String item) {
        this.refreshPictures(item, this.allPictures(item));
    }

    private void refreshPictures(String item, List<Mold.Block.Picture> pictures) {
        Record record = this.provider.record(new String(Base64.getDecoder().decode(item)));
        pictures.forEach(stamp -> {
            try {
                String name = stamp.name$();
                Object data = stamp.internalValue(record, this.provider.user().isPresent() ? this.provider.user().get().username() : null);
                if (!(data instanceof List) || ((List)data).size() != 1) {
                    return;
                }
                List values = (List)data;
                byte[] pictureBytes = IOUtils.toByteArray((InputStream)((URL)values.get(0)).openStream());
                byte[] picture = Base64.getEncoder().encode(pictureBytes);
                ((CatalogListViewDisplayNotifier)this.notifier).refreshPicture(PictureDataBuilder.build(record, name, "data:image/png;base64," + new String(picture)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void createClusterGroup(ClusterGroup value) {
        String username = this.session() != null && this.session().user() != null ? this.session().user().username() : null;
        List<Entity> entities = value.entities().stream().map(entityName -> (Entity)this.provider.record(new String(Base64.getDecoder().decode((String)entityName))).a$(Entity.class)).collect(Collectors.toList());
        Cluster cluster = ClusterHelper.registerClusterGroup(this.box, this.view.element(), value.cluster(), value.name(), entities, username);
        this.createClusterListeners.forEach(l -> l.accept(cluster));
    }

    protected void sendItems(int start, int limit) {
        ((CatalogListViewDisplayNotifier)this.notifier).refresh(RecordItemBuilder.buildList(this.provider.records(start, limit, this.condition, this.sorting), ElementHelper.recordItemDisplayProvider(this.provider, this.view), Asset.baseAssetUrl(this.session())));
    }

    protected void sendClear() {
        ((CatalogListViewDisplayNotifier)this.notifier).clear();
    }

    protected void sendPageSize(int pageSize) {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshPageSize(pageSize);
    }

    protected void sendCount(int count) {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshCount(count);
    }

    protected void init() {
        super.init();
        List<Catalog.Analysis.Sorting> sortings = this.provider.sortings();
        this.sorting = sortings.size() > 0 ? this.sortingOf(sortings.get(0)) : null;
        this.sendView();
        this.sendSortingList(sortings);
        this.sendSelectedSorting();
    }

    @Override
    public void refresh() {
        this.notifyLoading(true);
        super.refresh();
        this.notifyLoading(false);
    }

    private void sendView() {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshView(ElementViewBuilder.build(this.view));
    }

    private void sendSortingList(List<Catalog.Analysis.Sorting> sortings) {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshSortingList(CatalogSortingBuilder.buildList(sortings));
    }

    private void sendSelectedSorting() {
        if (this.sorting == null) {
            return;
        }
        ((CatalogListViewDisplayNotifier)this.notifier).refreshSelectedSorting(CatalogSortingBuilder.build(this.sorting));
    }

    private Map<Mold.Block.Display, StampDisplay> displays(String record) {
        List stamps = this.provider.stamps(this.view.mold()).stream().filter((? super T s) -> s.i$(Mold.Block.Display.class)).collect(Collectors.toList());
        Map<Mold.Block.Display, StampDisplay> nullableMap = stamps.stream().collect(Collectors.toMap(s -> (Mold.Block.Display)s.a$(Mold.Block.Display.class), stamp -> this.provider.display(stamp.name$())));
        Map<Mold.Block.Display, StampDisplay> result = nullableMap.entrySet().stream().filter((? super T e) -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        result.forEach((key, value) -> value.record(this.provider.record(record)));
        return result;
    }

    private List<Mold.Block.Picture> expandedPictures(String record) {
        return this.provider.expandedStamps(this.view.mold()).stream().filter((? super T s) -> s.i$(Mold.Block.Picture.class)).map(s -> (Mold.Block.Picture)s.a$(Mold.Block.Picture.class)).collect(Collectors.toList());
    }

    private List<Mold.Block.Picture> allPictures(String record) {
        return this.provider.stamps(this.view.mold()).stream().filter((? super T s) -> s.i$(Mold.Block.Picture.class)).map(s -> (Mold.Block.Picture)s.a$(Mold.Block.Picture.class)).collect(Collectors.toList());
    }

    private CatalogViewDisplayProvider.Sorting sortingOf(Sorting sorting) {
        return this.sortingOf(sorting.name(), sorting.mode());
    }

    private CatalogViewDisplayProvider.Sorting sortingOf(Catalog.Analysis.Sorting sorting) {
        return this.sortingOf(sorting.name$(), "Ascendant");
    }

    private CatalogViewDisplayProvider.Sorting sortingOf(final String name, final String mode) {
        return new CatalogViewDisplayProvider.Sorting(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public CatalogViewDisplayProvider.Sorting.Mode mode() {
                return CatalogViewDisplayProvider.Sorting.Mode.valueOf(mode);
            }

            @Override
            public int comparator(Record record1, Record record2) {
                return CatalogListViewDisplay.this.provider.sorting(name).comparator(record1, record2);
            }
        };
    }

    private void refresh(RecordItem item) {
        ((CatalogListViewDisplayNotifier)this.notifier).refreshItem(item);
        if (this.recordDisplaysMap.containsKey(item.name())) {
            this.recordDisplaysMap.get(item.name()).forEach(Display::refresh);
        }
    }

    public void itemRefreshed(String record) {
        this.refreshPictures(record);
    }

    private void notifyLoading(boolean value) {
        this.loadingListeners.forEach(l -> l.accept(value));
    }

    public void openItemDialogOperation(OpenItemDialogParameters params) {
        this.openItemDialogListeners.forEach(l -> l.accept(ElementHelper.openItemDialogEvent(params.item(), this.provider.stamp(this.view.mold(), params.stamp()))));
    }

    public void executeItemTaskOperation(ExecuteItemTaskParameters params) {
        this.executeItemTaskListeners.forEach(l -> l.accept(ElementHelper.executeItemTaskEvent(params.item(), this.provider.stamp(this.view.mold(), params.stamp()))));
    }

    public ActivityFile downloadItemOperation(DownloadItemParameters value) {
        return null;
    }

    public void executeOperation(ElementOperationParameters value) {
        this.provider.executeOperation(value, this.selectedRecords());
    }

    public ActivityFile downloadOperation(ElementOperationParameters value) {
        final Resource resource = this.provider.downloadOperation(value, this.selectedRecords());
        return new ActivityFile(){

            public String label() {
                return resource.label();
            }

            public InputStream content() {
                return resource.content();
            }
        };
    }

    private List<Record> selectedRecords() {
        return this.lastSelection.stream().map(name -> this.provider.record(new String(Base64.getDecoder().decode((String)name)))).collect(Collectors.toList());
    }

    public void saveItem(SaveItemParameters value) {
        if (this.selectedRecords().size() != 1) {
            return;
        }
        this.provider.saveItem(value, this.selectedRecords().get(0));
    }
}

