/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.Category;
import io.intino.sumus.CategoryMap;
import io.intino.sumus.RecordList;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.CatalogViewListDisplay;
import io.intino.sumus.box.displays.ElementDisplay;
import io.intino.sumus.box.displays.ElementViewDisplay;
import io.intino.sumus.box.displays.RecordDisplay;
import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.GroupingGroup;
import io.intino.sumus.box.schemas.GroupingSelection;
import io.intino.sumus.graph.AbstractView;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.OnClickRecord;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.Toolbar;
import io.intino.sumus.graph.entityholder.EntityHolderCatalog;
import io.intino.sumus.graph.eventholder.EventHolderCatalog;
import io.intino.sumus.graph.reportholder.ReportHolderCatalog;
import io.intino.sumus.queries.CatalogManager;
import io.intino.sumus.queries.Scope;
import io.intino.tara.magritte.Concept;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class CatalogDisplay<DN extends DisplayNotifier>
extends ElementDisplay<Catalog, DN>
implements CatalogViewDisplayProvider {
    private List<Consumer<ElementViewDisplay.OpenItemEvent>> openItemListeners = new ArrayList<Consumer<ElementViewDisplay.OpenItemEvent>>();
    protected Map<String, GroupingSelection> groupingSelectionMap = new HashMap<String, GroupingSelection>();
    protected Scope scope = null;
    private String condition = null;
    private RecordList<Record> recordList = null;
    private String currentRecord = null;
    protected CatalogManager manager;

    public CatalogDisplay(SumusBox box) {
        super(box);
    }

    protected List<Categorization> categorizations() {
        if (((Catalog)((Object)this.element())).analysis() == null) {
            return Collections.emptyList();
        }
        return ((Catalog)((Object)this.element())).analysis().groupingList().stream().map(Catalog.Analysis.Grouping::categorization).collect(Collectors.toList());
    }

    public boolean isFor(Catalog catalog) {
        return ((Catalog)((Object)this.element())).name$().equals(catalog.name$());
    }

    public void catalog(Catalog catalog) {
        this.element(catalog);
    }

    public void selectView(String name) {
        ((CatalogViewListDisplay)this.child(CatalogViewListDisplay.class)).selectView(name);
    }

    public void selectGrouping(GroupingSelection selection) {
        Catalog.Analysis.AbstractGrouping abstractGrouping = this.groupingOf(selection.name());
        if (selection.groups().size() <= 0 || abstractGrouping.histogram() == Catalog.Analysis.AbstractGrouping.Histogram.Absolute && selection.groups().size() <= 0) {
            this.groupingSelectionMap.remove(selection.name());
        } else {
            this.groupingSelectionMap.put(selection.name(), selection);
        }
        this.dirty(true);
        this.refreshGrouping();
    }

    public void deleteGroupingGroup(GroupingGroup groupingGroup) {
        Catalog.Analysis.AbstractGrouping abstractGrouping = this.groupingOf(groupingGroup.grouping());
        if (!abstractGrouping.i$(Catalog.Analysis.ClusterGrouping.class)) {
            return;
        }
        Catalog.Analysis.ClusterGrouping grouping = (Catalog.Analysis.ClusterGrouping)abstractGrouping.a$(Catalog.Analysis.ClusterGrouping.class);
        Cluster.Group group = grouping.cluster().groupList().stream().filter((? super T g) -> g.name$().equals(groupingGroup.name())).findFirst().orElse(null);
        if (group == null) {
            return;
        }
        group.delete$();
        grouping.cluster().save$();
        this.sendCatalog();
        if (this.groupingSelectionMap.containsKey(groupingGroup.grouping())) {
            GroupingSelection groupingSelection = this.groupingSelectionMap.get(groupingGroup.grouping());
            groupingSelection.groups().remove(group.label());
            this.selectGrouping(groupingSelection);
        }
    }

    public void refresh(Categorization categorization) {
        this.sendCatalog();
        this.currentView().ifPresent(ElementViewDisplay::refresh);
    }

    public void refreshViews() {
        ((CatalogViewListDisplay)this.child(CatalogViewListDisplay.class)).refresh();
    }

    @Override
    public Concept elementType() {
        Catalog catalog = (Catalog)((Object)this.element());
        if (catalog.i$(EntityHolderCatalog.class)) {
            return ((EntityHolderCatalog)catalog.a$(EntityHolderCatalog.class)).entity();
        }
        if (catalog.i$(EventHolderCatalog.class)) {
            return ((EventHolderCatalog)catalog.a$(EventHolderCatalog.class)).event();
        }
        if (catalog.i$(ReportHolderCatalog.class)) {
            return ((ReportHolderCatalog)catalog.a$(ReportHolderCatalog.class)).report();
        }
        return null;
    }

    @Override
    public int countRecords(String condition) {
        this.updateCondition(condition);
        this.loadRecordList();
        return this.recordList.count();
    }

    @Override
    public List<Record> records(int start, int limit, String condition) {
        return this.records(start, limit, condition, null);
    }

    @Override
    public List<Record> records(int start, int limit, String condition, CatalogViewDisplayProvider.Sorting sorting) {
        this.updateCondition(condition);
        this.loadRecordList();
        return this.recordList.items(start, limit, sorting);
    }

    @Override
    protected Record currentRecord() {
        return this.record(this.currentRecord);
    }

    @Override
    protected void currentRecord(String id) {
        this.currentRecord = id;
    }

    @Override
    public Record record(String key) {
        Record record = null;
        if (!this.dirty() && this.recordList != null) {
            record = this.recordList.items().stream().filter((? super T r) -> r.core$().id().equals(key) || r.core$().name().equals(key)).findFirst().orElse(null);
        }
        return record != null ? record : this.loadRecord(key);
    }

    @Override
    public List<Catalog.Analysis.Sorting> sortings() {
        if (((Catalog)((Object)this.element())).analysis() == null) {
            return Collections.emptyList();
        }
        return ((Catalog)((Object)this.element())).analysis().sortingList();
    }

    @Override
    public Catalog.Analysis.Sorting sorting(String key) {
        if (((Catalog)((Object)this.element())).analysis() == null) {
            return null;
        }
        return ((Catalog)((Object)this.element())).analysis().sortingList().stream().filter((? super T s) -> s.name$().equals(key) || s.label().equals(key)).findFirst().orElse(null);
    }

    public void onOpenItem(Consumer<ElementViewDisplay.OpenItemEvent> listener) {
        this.openItemListeners.add(listener);
    }

    protected void resetGrouping() {
        this.groupingSelectionMap.clear();
        this.scope = null;
        this.queryEngine().filter(this.scope);
    }

    protected void refreshGrouping() {
        this.refreshScope();
        this.queryEngine().filter(this.scope);
        this.refreshView();
        this.sendCatalog();
    }

    protected void init() {
        super.init();
        this.createCatalogManager();
        this.buildViewList();
        this.sendCatalog();
        this.createRecordDisplay();
        this.createDialogContainer();
    }

    protected ElementView<Catalog> catalogViewOf(final AbstractView view) {
        return new ElementView<Catalog>(){

            @Override
            public String name() {
                return view.core$().name();
            }

            @Override
            public String label() {
                return view.label();
            }

            @Override
            public String type() {
                return ((Object)((Object)view)).getClass().getSimpleName();
            }

            @Override
            public String option() {
                if (!view.i$(Catalog.OlapView.class)) {
                    return null;
                }
                return ((Catalog.OlapView)view.a$(Catalog.OlapView.class)).olap().name$();
            }

            @Override
            public <V extends AbstractView> V raw() {
                return (V)((Object)view);
            }

            @Override
            public boolean embeddedElement() {
                return CatalogDisplay.this.embedded();
            }

            @Override
            public Toolbar toolbar() {
                return this.element().toolbar();
            }

            @Override
            public int width() {
                if (view.i$(Catalog.MagazineView.class)) {
                    return ((Catalog.MagazineView)view.a$(Catalog.MagazineView.class)).width();
                }
                if (view.i$(Catalog.ListView.class)) {
                    return ((Catalog.ListView)view.a$(Catalog.ListView.class)).width();
                }
                if (view.i$(Catalog.GridView.class)) {
                    return ((Catalog.GridView)view.a$(Catalog.GridView.class)).width();
                }
                return 100;
            }

            @Override
            public Mold mold() {
                if (view.i$(Catalog.MagazineView.class)) {
                    return ((Catalog.MagazineView)view.a$(Catalog.MagazineView.class)).mold();
                }
                if (view.i$(Catalog.ListView.class)) {
                    return ((Catalog.ListView)view.a$(Catalog.ListView.class)).mold();
                }
                if (view.i$(Catalog.GridView.class)) {
                    return ((Catalog.GridView)view.a$(Catalog.GridView.class)).mold();
                }
                if (view.i$(Catalog.MapView.class)) {
                    return ((Catalog.MapView)view.a$(Catalog.MapView.class)).mold();
                }
                return null;
            }

            @Override
            public OnClickRecord onClickRecordEvent() {
                Catalog.Events events = ((Catalog)((Object)CatalogDisplay.this.element())).events();
                return events != null ? events.onClickRecord() : null;
            }

            @Override
            public boolean canCreateClusters() {
                return CatalogDisplay.this.canCreateClusters();
            }

            @Override
            public boolean canSearch() {
                return CatalogDisplay.this.canSearch();
            }

            @Override
            public List<String> clusters() {
                if (this.element().analysis() == null) {
                    return Collections.emptyList();
                }
                return this.element().analysis().clusterGroupingList().stream().map(Catalog.Analysis.AbstractGrouping::label).collect(Collectors.toList());
            }

            @Override
            public Record target() {
                return CatalogDisplay.this.target();
            }

            @Override
            public Catalog element() {
                return (Catalog)((Object)CatalogDisplay.this.element());
            }

            @Override
            public String emptyMessage() {
                if (view.i$(Catalog.MagazineView.class)) {
                    return ((Catalog.MagazineView)view.a$(Catalog.MagazineView.class)).noRecordMessage();
                }
                if (view.i$(Catalog.ListView.class)) {
                    return ((Catalog.ListView)view.a$(Catalog.ListView.class)).noRecordsMessage();
                }
                if (view.i$(Catalog.GridView.class)) {
                    return ((Catalog.GridView)view.a$(Catalog.GridView.class)).noRecordsMessage();
                }
                return null;
            }
        };
    }

    protected abstract void createCatalogManager();

    protected abstract void sendCatalog();

    protected abstract <R extends Record> RecordList<R> records(String var1);

    protected abstract boolean canCreateClusters();

    protected boolean isGrouping(Map.Entry<String, GroupingSelection> entry) {
        return this.groupingOf(entry.getKey()).i$(Catalog.Analysis.Grouping.class);
    }

    protected boolean isCluster(Map.Entry<String, GroupingSelection> entry) {
        return this.groupingOf(entry.getKey()).i$(Catalog.Analysis.ClusterGrouping.class);
    }

    private List<ElementView> viewList() {
        return this.views().stream().map(this::catalogViewOf).collect(Collectors.toList());
    }

    private boolean canSearch() {
        Toolbar toolbar = ((Catalog)((Object)this.element())).asHolder().toolbar();
        return toolbar == null || toolbar.canSearch();
    }

    private void updateCondition(String condition) {
        if (this.condition != null && !this.condition.equals(condition)) {
            this.dirty(true);
        }
        this.condition = condition;
    }

    private void loadRecordList() {
        if (!this.dirty() && this.recordList != null) {
            return;
        }
        this.recordList = this.records(this.condition);
        this.dirty(false);
    }

    private void buildViewList() {
        CatalogViewListDisplay display = new CatalogViewListDisplay(this.box);
        display.recordProvider(this);
        display.viewList(this.viewList());
        display.onSelectView(this::updateCurrentView);
        display.onOpenItem(this::openItem);
        display.onOpenItemDialog(this::openItemDialog);
        display.onExecuteItemTask(this::executeItemTask);
        display.onLoading(this::notifyLoading);
        display.onCreateCluster(this::refreshCatalog);
        this.add(display);
        display.personifyOnce();
    }

    @Override
    protected void openItem(ElementViewDisplay.OpenItemEvent parameters) {
        if (parameters.panel() == null) {
            return;
        }
        if (this.openItemListeners.size() > 0) {
            this.openItemListeners.forEach(l -> l.accept(parameters));
            return;
        }
        super.openItem(parameters);
    }

    private void refreshCatalog(Cluster cluster) {
        this.sendCatalog();
    }

    private void refreshScope() {
        if (this.groupingSelectionMap.size() <= 0) {
            this.scope = null;
            return;
        }
        if (this.scope == null) {
            this.scope = new Scope();
        }
        this.manager.clearFilter();
        this.scope.clear();
        this.scope.categories(this.groupingSelectionMap.entrySet().stream().filter(this::isGrouping).collect(Collectors.toMap(Map.Entry::getKey, e -> this.categories((GroupingSelection)e.getValue()))));
        this.scope.records(this.groupingSelectionMap.entrySet().stream().filter(this::isCluster).collect(Collectors.toMap(Map.Entry::getKey, e -> this.records((GroupingSelection)e.getValue()))));
        this.groupingSelectionMap.values().stream().filter((? super T g) -> this.groupingOf(g.name()).i$(Catalog.Analysis.Grouping.class)).forEach(selection -> this.manager.filter(this.categorizationOf((GroupingSelection)selection).name$(), selection.groups()));
    }

    private Categorization categorizationOf(GroupingSelection selection) {
        Catalog.Analysis.AbstractGrouping abstractGrouping = this.groupingOf(selection.name());
        if (!abstractGrouping.i$(Catalog.Analysis.Grouping.class)) {
            return null;
        }
        return ((Catalog.Analysis.Grouping)abstractGrouping.a$(Catalog.Analysis.Grouping.class)).categorization();
    }

    private List<Category> categories(GroupingSelection selection) {
        CategoryMap categoryMap = this.manager.categories(this.categorizationOf(selection));
        return categoryMap != null ? selection.groups().stream().map(categoryMap::get).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<Record> records(GroupingSelection selection) {
        return selection.groups().stream().map(group -> this.records(selection.name(), (String)group)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Record> records(String groupingName, String groupName) {
        Catalog.Analysis.AbstractGrouping grouping = this.groupingOf(groupingName);
        return this.recordsOf(grouping, groupName);
    }

    private List<Record> recordsOf(Catalog.Analysis.AbstractGrouping grouping, String groupLabel) {
        Catalog.Analysis.ClusterGrouping clusterGrouping = (Catalog.Analysis.ClusterGrouping)grouping.a$(Catalog.Analysis.ClusterGrouping.class);
        Cluster.Group group = clusterGrouping.cluster().groupList().stream().filter((? super T g) -> g.label().equals(groupLabel)).findFirst().orElse(null);
        return group != null ? group.entities().stream().map(e -> (Record)e.a$(Record.class)).collect(Collectors.toList()) : Collections.emptyList();
    }

    private Catalog.Analysis.AbstractGrouping groupingOf(String groupingName) {
        if (((Catalog)((Object)this.element())).analysis() == null) {
            return null;
        }
        return ((Catalog)((Object)this.element())).analysis().abstractGroupingList().stream().filter((? super T g) -> g.name$().equals(groupingName)).findFirst().orElse(null);
    }

    private void createRecordDisplay() {
        RecordDisplay display = new RecordDisplay(this.box);
        this.add(display);
        display.personifyOnce();
    }
}

