/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.konos.BoxConfiguration;
import io.intino.konos.server.activity.services.AuthService;
import io.intino.sumus.box.SumusBox;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class SumusConfiguration
extends BoxConfiguration {
    PlatformActivityConfiguration platformConfiguration;

    public SumusConfiguration(String[] args) {
        super(args);
        this.fillWithArgs();
    }

    private void fillWithArgs() {
        if (this.store == null && this.args.get("graph_store") != null) {
            this.store = new File((String)this.args.remove("graph_store"));
        }
        if (this.args.containsKey("platform_port")) {
            this.platformConfiguration(this.toInt((String)this.args.remove("platform_port")), (String)this.args.remove("platform_webDirectory"), (String)this.args.remove("platform_federationUrl"), (String)this.args.remove("platform_analyticsPath"));
            this.platformConfiguration.authService = SumusBox.authService(this.platformConfiguration.authServiceUrl());
        }
    }

    public File store() {
        return this.store;
    }

    public SumusConfiguration platformConfiguration(int port, String webDirectory, String federationUrl, String analyticsPath) {
        this.platformConfiguration = new PlatformActivityConfiguration();
        this.platformConfiguration.port = port;
        this.platformConfiguration.webDirectory = webDirectory == null ? "www/" : webDirectory;
        this.platformConfiguration.federationUrl = federationUrl;
        this.platformConfiguration.analyticsPath = analyticsPath;
        return this;
    }

    public SumusConfiguration platformConfiguration(int port, String federationUrl, String analyticsPath) {
        return this.platformConfiguration(port, "www/", federationUrl, analyticsPath);
    }

    public PlatformActivityConfiguration platformConfiguration() {
        return this.platformConfiguration;
    }

    public static class PlatformActivityConfiguration {
        public int port;
        public String webDirectory;
        public AuthService authService;
        public String federationUrl = "";
        public String analyticsPath = "";

        public URL authServiceUrl() {
            try {
                return new URL("{federationUrl}".replace("{federationUrl}", this.federationUrl).replace("{analyticsPath}", this.analyticsPath));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }
}

