/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.konos.Box;
import io.intino.konos.LogFormatter;
import io.intino.konos.server.activity.ActivityKonosSpark;
import io.intino.konos.server.activity.displays.Soul;
import io.intino.konos.server.activity.services.AuthService;
import io.intino.sumus.box.PlatformActivity;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.SumusConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBox
extends Box {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    protected SumusConfiguration configuration;
    protected Map<String, Soul> activitySouls = new HashMap<String, Soul>();

    public AbstractBox(String[] args) {
        this(new SumusConfiguration(args));
    }

    public AbstractBox(SumusConfiguration configuration) {
        this.configuration = configuration;
        if (this.configuration().platformConfiguration != null) {
            ActivityKonosSpark.setup((int)this.configuration().platformConfiguration.port, (String)this.configuration().platformConfiguration.webDirectory, (AuthService)this.configuration().platformConfiguration.authService);
        }
    }

    public SumusConfiguration configuration() {
        return this.configuration;
    }

    public Box put(Object o) {
        return this;
    }

    public Box open() {
        if (this.owner != null) {
            this.owner.open();
        }
        this.initActivities();
        this.initRESTServices();
        this.initJMXServices();
        this.initJMSServices();
        this.initDataLake();
        this.initTasks();
        this.initSlackBots();
        return this;
    }

    public void close() {
        if (this.owner != null) {
            this.owner.close();
        }
        ActivityKonosSpark.instance().stop();
    }

    public void registerSoul(String clientId, Soul soul) {
        this.activitySouls.put(clientId, soul);
    }

    public void unRegisterSoul(String clientId) {
        this.activitySouls.remove(clientId);
    }

    private void initRESTServices() {
    }

    private void initJMSServices() {
    }

    private void initJMXServices() {
    }

    private void initSlackBots() {
    }

    private void initActivities() {
        if (this.configuration().platformConfiguration == null) {
            return;
        }
        PlatformActivity.init(ActivityKonosSpark.instance(), (SumusBox)this).start();
        logger.info("Activity Platform: started!");
    }

    private void initDataLake() {
    }

    private void initTasks() {
    }

    private void initLogger() {
        java.util.logging.Logger logger = java.util.logging.Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter((Formatter)new LogFormatter("log"));
        logger.addHandler(handler);
    }
}

