/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.viewmodels;

import io.intino.sumus.Category;
import io.intino.sumus.analytics.viewmodels.CategorizationView;
import io.intino.sumus.graph.Categorization;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CategorizationViewBuilder {
    public static CategorizationView build(Categorization categorization, List<String> keys) {
        return CategorizationViewBuilder.createCategorizationView(categorization, Collections.emptyList(), keys);
    }

    public static List<CategorizationView> build(List<? extends Categorization> categorizations, Map<Categorization, List<Category>> disallowed, List<String> keys) {
        return categorizations.stream().map(categorization -> CategorizationViewBuilder.buildView(categorization, disallowed, keys)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<CategorizationView> buildView(Categorization categorization, Map<Categorization, List<Category>> disallowed, List<String> keys) {
        return Collections.singletonList(CategorizationViewBuilder.createCategorizationView(categorization, CategorizationViewBuilder.disallowedCategories(disallowed.values()), keys));
    }

    private static CategorizationView createCategorizationView(Categorization categorization, List<Category> disallowedCategories, List<String> keys) {
        if (disallowedCategories.isEmpty()) {
            return new CategorizationView(categorization, categorization.calculate(keys));
        }
        List<Category> categories = categorization.calculate(keys).stream().filter(disallowedCategories::contains).collect(Collectors.toList());
        return new CategorizationView(categorization, categories.isEmpty() ? categorization.calculate(keys) : categories);
    }

    private static List<Category> disallowedCategories(Collection<List<Category>> disallowed) {
        return disallowed.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

