/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.exporters;

import io.intino.sumus.analytics.exporters.Document;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractDocument
implements Document {
    private final String language;

    protected AbstractDocument(String language) {
        this.language = language;
    }

    protected Dictionary dictionary() {
        return new Dictionary().register(this.spanish()).register(this.english());
    }

    protected String translate(String word) {
        return this.dictionary().language(this.language).translate(word);
    }

    private Dictionary.Language spanish() {
        return new Dictionary.Language().key("es").translation("Time", "Instante").translation("Indicator", "Indicador").translation("Ticket", "Ticket").translation("Value", "Valor").translation("DrillCategorization", "Categorizaci\u00f3n").translation("DrillCategory", "Categor\u00eda").translation("FilterCategorization", "Filtro de categorizaci\u00f3n").translation("FilterCategory", "Filtro de categor\u00eda");
    }

    private Dictionary.Language english() {
        return new Dictionary.Language().key("en").translation("Time", "Instant").translation("Indicator", "Indicator").translation("Ticket", "Ticket").translation("Value", "Value").translation("DrillCategorization", "Categorization").translation("DrillCategory", "Category").translation("FilterCategorization", "Filter categorization").translation("FilterCategory", "Filter category");
    }

    protected static class Dictionary {
        private Map<String, Language> languages = new HashMap<String, Language>();

        protected Dictionary() {
        }

        public Language language(String key) {
            return this.languages.get(key);
        }

        public Dictionary register(Language language) {
            this.languages.put(language.key, language);
            return this;
        }

        protected static class Language {
            String key;
            Map<String, String> translations = new HashMap<String, String>();

            protected Language() {
            }

            public Language key(String key) {
                this.key = key;
                return this;
            }

            public Language translation(String word, String value) {
                this.translations.put(word, value);
                return this;
            }

            public String translate(String word) {
                return this.translations.get(word);
            }
        }
    }
}

