package io.intino.sumus.helpers;

import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.ProfileManager;
import io.intino.sumus.graph.SumusGraph;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class NameSpaceHandler {
	private final SumusGraph graph;
	private NameSpace selected = null;
	private List<Consumer<NameSpace>> listeners = new ArrayList<>();

	public NameSpaceHandler(SumusGraph graph) {
		this.graph = graph;
	}

	public void onSelect(Consumer<NameSpace> listener) {
		this.listeners.add(listener);
	}

	public NameSpace selectedNameSpace(String username) {
		if (selected != null) return selected;

		List<NameSpace> nameSpaces = nameSpaces(username);
		if (nameSpaces.size() > 0)
			selected = nameSpaces.get(0);

		return selected;
	}

	public NameSpaceHandler select(String key) {
		select(nameSpaces(null).stream().filter(n -> n.name$().equals(key) || n.label().equals(key)).findFirst().orElse(null));
		return this;
	}

	public NameSpaceHandler select(NameSpace nameSpace) {
		selected = nameSpace;
		this.listeners.forEach(l -> l.accept(nameSpace));
		return this;
	}

	public List<NameSpace> nameSpaces(String username) {
		ProfileManager manager = graph.profileManager();
		if (manager == null || username == null) return graph.nameSpaceList();
		return manager.profile(username).nameSpaces();
	}

}
