package io.intino.sumus.box.resources;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.actions.AnalyticsPageAction;
import io.intino.konos.exceptions.KonosException;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;

import java.util.Base64;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class AnalyticsPageResource extends io.intino.konos.server.activity.spark.resources.Resource {
	private final SumusBox box;

	public AnalyticsPageResource(SumusBox box, io.intino.konos.server.activity.spark.ActivitySparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
		this.box = box;
	}

	@Override
	public void execute() throws KonosException {
		super.execute();

		if (isLogged()) render();
		else authenticate();
	}

	private void render() {
		String clientId = UUID.randomUUID().toString();
		AnalyticsPageAction action = new AnalyticsPageAction();
		action.session = manager.currentSession();
		action.session.whenLogin(new Function<String, String>() {
			@Override
			public String apply(String baseUrl) {
				return AnalyticsPageResource.this.authenticate(baseUrl);
			}
		});
		action.session.whenLogout(b -> logout());
		action.box = box;
		action.clientId = clientId;

		manager.pushService().onOpen(client -> {
			if (!client.id().equals(action.clientId))
				return false;

			if (client.soul() != null)
				return false;

			io.intino.konos.server.activity.displays.Soul soul = action.prepareSoul(client);
			soul.addRegisterDisplayListener(display -> {
				display.inject(notifier(action.session, client, display));
				display.inject(action.session);
				display.inject(soul);
				display.inject(() -> soul);
			});
			client.soul(soul);
			box.registerSoul(clientId, soul);

			return true;
		});

		manager.pushService().onClose(clientId).execute(new Consumer<io.intino.konos.server.activity.services.push.ActivityClient>() {
			@Override
			public void accept(io.intino.konos.server.activity.services.push.ActivityClient client) {
				box.unRegisterSoul(client.id());
				manager.unRegister(client);
			}
		});

		manager.write(action.execute());
	}

}