package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.FilterListDisplay;
import io.intino.konos.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.FilterListDisplayNotifier;

import io.intino.konos.exceptions.KonosException;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;
import io.intino.konos.server.activity.spark.ActivitySparkManager;
import io.intino.konos.server.activity.spark.resources.DisplayRequester;

public class FilterListDisplayRequester extends DisplayRequester {

	public FilterListDisplayRequester(ActivitySparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws KonosException {
		FilterListDisplay display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("addFilter")) display.addFilter();
		else if (operation.equals("saveFilter")) display.saveFilter(manager.fromQuery("value", FilterDialog.class));
		else if (operation.equals("removeFilter")) display.removeFilter(manager.fromQuery("value", String.class));
		else if (operation.equals("selectFilter")) display.selectFilter(manager.fromQuery("value", String.class));
		else if (operation.equals("applyFilter")) display.applyFilter(manager.fromQuery("value", String.class));
		else if (operation.equals("quitFilter")) display.quitFilter(manager.fromQuery("value", String.class));
	}
}