package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.FilterDisplay;
import io.intino.konos.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.FilterDisplayNotifier;

import io.intino.konos.exceptions.KonosException;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;
import io.intino.konos.server.activity.spark.ActivitySparkManager;
import io.intino.konos.server.activity.spark.resources.DisplayRequester;

public class FilterDisplayRequester extends DisplayRequester {

	public FilterDisplayRequester(ActivitySparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws KonosException {
		FilterDisplay display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("addCategorization")) display.addCategorization(manager.fromQuery("value", String.class));
		else if (operation.equals("removeCategorization")) display.removeCategorization(manager.fromQuery("value", String.class));
		else if (operation.equals("apply")) display.apply();
		else if (operation.equals("quit")) display.quit();
	}
}