package io.intino.sumus.box.displays.requesters;

import io.intino.sumus.box.displays.CategorizationDisplay;
import io.intino.konos.exceptions.*;
import io.intino.sumus.box.*;
import io.intino.sumus.box.schemas.*;

import io.intino.sumus.box.displays.notifiers.CategorizationDisplayNotifier;

import io.intino.konos.exceptions.KonosException;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;
import io.intino.konos.server.activity.spark.ActivitySparkManager;
import io.intino.konos.server.activity.spark.resources.DisplayRequester;

public class CategorizationDisplayRequester extends DisplayRequester {

	public CategorizationDisplayRequester(ActivitySparkManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws KonosException {
		CategorizationDisplay display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("toggle")) display.toggle(manager.fromQuery("value", CategorizationToggleDialog.class));
		else if (operation.equals("select")) display.select(manager.fromQuery("value", String[].class));
		else if (operation.equals("selectAll")) display.selectAll();
		else if (operation.equals("selectNone")) display.selectNone();
	}
}