package io.intino.sumus.box.displays.providers;

import io.intino.konos.server.activity.services.push.User;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.box.displays.CatalogInstantBlock;
import io.intino.sumus.box.displays.ElementDisplay;
import io.intino.sumus.box.displays.ElementDisplayManager;
import io.intino.sumus.box.displays.StampDisplay;
import io.intino.sumus.box.schemas.ElementOperationParameters;
import io.intino.sumus.box.schemas.SaveItemParameters;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.Resource;
import io.intino.sumus.helpers.NameSpaceHandler;

import java.util.List;
import java.util.Optional;

public interface ElementViewDisplayProvider {
    Element element();
    Record record(String id);
    Optional<User> user();
    boolean embedded();

    NameSpaceHandler nameSpaceHandler();
    ElementDisplayManager elementDisplayManager();
    TimeRange range();

    void selectInstant(CatalogInstantBlock block);

    <E extends ElementDisplay> E openElement(String label);

    List<Mold.Block> blocks(Mold mold);
    List<Mold.Block.Stamp> stamps(Mold mold);
    List<Mold.Block.Stamp> expandedStamps(Mold mold);
    Mold.Block.Stamp stamp(Mold mold, String name);

    StampDisplay display(String stamp);

    void executeOperation(ElementOperationParameters params, List<Record> selection);
    Resource downloadOperation(ElementOperationParameters params, List<Record> selection);
    void saveItem(SaveItemParameters params, Record record);
}

