package io.intino.sumus.box.displays.providers;

import io.intino.sumus.box.displays.CatalogInstantBlock;
import io.intino.sumus.box.schemas.ElementOperationParameters;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.Resource;
import io.intino.tara.magritte.Concept;

import java.util.List;

public interface CatalogViewDisplayProvider extends ElementViewDisplayProvider {
    Concept elementType();
    Record target();

    int countRecords(String condition);
    List<Record> records(int start, int limit, String condition);
    List records(int start, int limit, String condition, Sorting sorting);
    Record rootRecord(List<Record> recordList);
    Record defaultRecord(String name);
    List<Catalog.Analysis.Sorting> sortings();

    Catalog.Analysis.Sorting sorting(String name);
    void executeOperation(ElementOperationParameters params, List<Record> selection);
    Resource downloadOperation(ElementOperationParameters params, List<Record> selection);

    interface Sorting {
        String name();
        Mode mode();
        int comparator(Record record1, Record record2);
        enum Mode { Ascendant, Descendant }
    }
}

