package io.intino.sumus.box.displays.builders;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import io.intino.sumus.Settings;
import io.intino.sumus.box.schemas.PlatformInfo;

import java.io.IOException;
import java.net.URL;

import static org.apache.commons.io.IOUtils.toByteArray;

public class PlatformInfoBuilder {

    public static PlatformInfo build(Settings settings, URL authServiceUrl) {
        PlatformInfo info = new PlatformInfo().title(settings.title())
                .subtitle(settings.subtitle())
                .logo(logo(settings));

        if (authServiceUrl != null)
            info.authServiceUrl(authServiceUrl.toString());

        return info;
    }

    private static String logo(Settings settings) {
        try {
            return toBase64(settings.logo());
        } catch (Exception e) {
            return "";
        }
    }

    private static String toBase64(URL resource) throws IOException {
        return "data:image/png;base64," + Base64.encode(toByteArray(resource.openStream()));
    }

}
