package io.intino.sumus.box.displays.builders;

import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.schemas.Item;
import io.intino.sumus.box.schemas.ItemProperty;
import io.intino.sumus.graph.*;

import java.util.List;

import static java.util.Collections.singletonList;
import static java.util.stream.Collectors.toList;

public class ItemBuilder {

    public static <T extends Categorization> Item build(T categorization) {
        return new Item().name(categorization.name$()).label(categorization.label());
    }

    public static <T extends Categorization> List<Item> buildList(List<T> categorizationList) {
        return categorizationList.stream().map(ItemBuilder::build).collect(toList());
    }

    public static Item build(String name, String label) {
        return new Item().name(name).label(label);
    }

    public static Item build(AbstractView view) {
        String type = typeOf(view);
        Item result = new Item().name(view.name$()).label(view.label());
        result.itemPropertyList().add(new ItemProperty().name("type").value(type));
        return result;
    }

    public static Item build(Element element) {
        return new Item().name(element.name$()).label(element.label());
    }

    public static Item build(Olap olap) {
        return new Item().name(olap.name$()).label(olap.label());
    }

    public static List<Item> buildOlapList(List<Olap> olapList) {
        return olapList.stream().map(ItemBuilder::build).collect(toList());
    }

    public static Item build(Filter filter) {
        return new Item().name(filter.name$()).label(filter.label());
    }

    public static List<Item> buildFilterList(List<Filter> filterList) {
        return filterList.stream().map(ItemBuilder::build).collect(toList());
    }

    public static Item build(ElementView view) {
        return new Item().name(view.name()).label(view.label()).itemPropertyList(singletonList(new ItemProperty().name("type").value(view.type())));
    }

    public static List<Item> buildCatalogList(List<Catalog> catalogList) {
        return catalogList.stream().map(ItemBuilder::build).collect(toList());
    }

    public static List<Item> buildCatalogViewList(List<ElementView> viewList) {
        return viewList.stream().map(ItemBuilder::build).collect(toList());
    }

    private static String typeOf(AbstractView view) {
        if (!view.i$(Panel.View.class)) return "";

        ElementRender render = view.a$(Panel.View.class).elementRender();
        if (render.i$(RenderMold.class)) return "custom-view";
        if (render.i$(RenderCatalog.class)) return "catalog-view";
        if (render.i$(RenderOlap.class)) return "olap-view";

        return "";
    }

}
