package io.intino.sumus.box.displays.builders;

import io.intino.sumus.box.schemas.Formatter;
import io.intino.sumus.graph.Olap;

import java.util.List;

import static io.intino.sumus.box.displays.adapters.FormatterAdapter.adapt;
import static io.intino.sumus.box.schemas.ActivitySchemaAdapters.formatterFromLayer;
import static java.util.stream.Collectors.toList;

public class FormatterBuilder {

    public static List<Formatter> buildList(List<Olap.InstantFormatter.Formatter> formatterList) {
        return formatterList.stream().map(formatter -> adapt(formatterFromLayer(formatter), formatter)).collect(toList());
    }

}
