package io.intino.sumus.box.displays.builders;

import io.intino.sumus.box.displays.providers.CatalogViewDisplayProvider;
import io.intino.sumus.box.schemas.ActivitySchemaAdapters;
import io.intino.sumus.box.schemas.Sorting;
import io.intino.sumus.graph.Catalog;

import java.util.List;

import static java.util.stream.Collectors.toList;

public class CatalogSortingBuilder {

    public static Sorting build(Catalog.Analysis.Sorting sorting) {
        return ActivitySchemaAdapters.sortingFromLayer(sorting);
    }

    public static Sorting build(CatalogViewDisplayProvider.Sorting sorting) {
        return new Sorting().name(sorting.name()).mode(sorting.mode().toString());
    }

    public static Sorting build(String name, String mode) {
        return new Sorting().name(name).mode(mode);
    }

    public static List<Sorting> buildList(List<Catalog.Analysis.Sorting> sortingList) {
        return sortingList.stream().map(CatalogSortingBuilder::build).collect(toList());
    }

}
