package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.builders.ItemBuilder;
import io.intino.sumus.box.displays.notifiers.TimeBarChartDialogDisplayNotifier;

import static io.intino.sumus.box.displays.TimeBarChartDisplay.Tag;
import static io.intino.sumus.graph.rules.Chart.TimeBarChart;

public class TimeBarChartDialogDisplay extends TimeHistogramDialogDisplay<TimeBarChartDialogDisplayNotifier> {
    public TimeBarChartDialogDisplay(SumusBox box) {
        super(box, TimeBarChart, Tag);
    }

    @Override
    protected void sendTickets() {
    }

    @Override
    public void addNavigatorListeners(TimeNavigatorDisplay display) {
        display.onMove(instant -> chartSpecHandler().update());
    }

    @Override
    protected void sendCategorizations() {
        notifier.refreshCategorizationList(ItemBuilder.buildList(categorizations()));
    }

    @Override
    protected void sendCategorization() {
        notifier.refreshCategorization(ItemBuilder.build(categorization()));
    }

    public void selectCategorization(String value) {
        super.selectCategorization(value);
    }
}