package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.konos.server.activity.services.push.ActivityClient;
import io.intino.konos.server.activity.services.push.ActivitySession;
import io.intino.konos.server.activity.services.push.User;
import io.intino.sumus.QueryEngine;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.Catalog;
import io.intino.sumus.graph.ProfileManager;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.rules.TimeScale;
import io.intino.tara.magritte.Concept;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;

public class SumusDisplay<N extends DisplayNotifier> extends Display<N> {
    private QueryEngine queryEngine;
    final SumusBox box;

    public SumusDisplay(SumusBox box) {
        this.box = box;
    }

    public Optional<User> user() {
        return Optional.ofNullable(session().user());
    }

    public String username() {
        return user().isPresent() ? user().get().username() : session().id();
    }

    SumusGraph platform() {
        return box.graph();
    }

    List<String> keys() {
        ProfileManager profileManager = platform().profileManager();

        if (profileManager == null)
            return emptyList();

        return profileManager.profile(username()).keys();
    }

    String currentLanguage() {
        ActivitySession session = session();
        if (session == null) return "en";
        ActivityClient client = (ActivityClient) session.currentClient();
        return client != null ? client.language() : session().browser().languageFromMetadata();
    }

    List<TimeScale> localizedScales(List<TimeScale> scales) {
        return scales.stream().map(this::scaleWithLabel).collect(toList());
    }

    TimeScale scaleWithLabel(TimeScale scale) {
        scale.label(box.translatorHelper().translate(scale.toString()).into(currentLanguage()));
        return scale;
    }

    URL baseAssetUrl() {
        try {
            return new URL(session().browser().baseAssetUrl());
        } catch (MalformedURLException e) {
            return null;
        }
    }

    public QueryEngine queryEngine() {
        if (queryEngine == null)
            queryEngine = new QueryEngine(box);
        return queryEngine;
    }

    int timezoneOffset() {
        return session().browser().timezoneOffset();
    }

    void timezoneOffset(int value) {
        session().browser().timezoneOffset(value/60);
    }

    Concept holderConceptOf(Catalog catalog) {
        if (catalog.isEventHolder()) return catalog.asEventHolder().event();
        else if (catalog.isEntityHolder()) return catalog.asEntityHolder().entity();
        else if (catalog.isReportHolder()) return catalog.asReportHolder().report();
        return null;
    }

}
