package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.notifiers.PanelOlapViewDisplayNotifier;
import io.intino.sumus.graph.*;

import java.util.List;

public class PanelOlapViewDisplay extends PanelViewDisplay<PanelOlapViewDisplayNotifier> {

    public PanelOlapViewDisplay(SumusBox box) {
        super(box);
    }

    @Override
    protected void init() {
        super.init();
        createOlapDisplay();
    }

    private void createOlapDisplay() {
        Panel.View rawView = view().raw();
        RenderOlap render = rawView.elementRender().a$(RenderOlap.class);
        Olap olap = render.olap();
        OlapDisplay display = new OlapDisplay(box);
        display.nameSpaceHandler(provider().nameSpaceHandler());
        display.olap(olap);
        display.onLoading(this::notifyLoading);
        display.onSelect(this::selectInstant);
        add(display);
        display.personifyOnce(id());
    }

    private void selectInstant(CatalogInstantBlock block) {
        CatalogDisplay display = provider().openElement(block.catalog());
        List<String> entities = block.entities();
        display.filterAndNotify(record -> entities.contains(((Record)record).core$().id()));
        display.refreshView();
    }

}