package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.notifiers.PanelCustomViewDisplayNotifier;

import static io.intino.sumus.helpers.ElementHelper.recordDisplayProvider;

public class PanelCustomViewDisplay extends PanelViewDisplay<PanelCustomViewDisplayNotifier> {

	public PanelCustomViewDisplay(SumusBox box) {
		super(box);
	}

	@Override
	protected void init() {
		super.init();
		createRecordDisplay();
	}

	@Override
	public void refresh() {
		super.refresh();
		child(RecordDisplay.class).refresh();
	}

	private void createRecordDisplay() {
		ElementView view = view();
		RecordDisplay display = new RecordDisplay(box);
		display.mold(view.mold());
		display.context(context());
		display.record(target());
		display.mode("custom");
		display.provider(recordDisplayProvider(provider(), view));
		display.onOpenItem(this::notifyOpenItem);
		display.onOpenItemDialog(this::notifyOpenItemDialog);
		display.onExecuteItemTask(this::notifyExecuteItemTaskOperation);
		add(display);
		display.personifyOnce();
	}

}