package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.Display;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.notifiers.PageContainerDisplayNotifier;
import io.intino.sumus.box.schemas.PageLocation;

public class PageContainerDisplay extends Display<PageContainerDisplayNotifier> {
    private SumusBox box;
    private PageLocation location;

    public PageContainerDisplay(SumusBox box) {
        super();
        this.box = box;
    }

    public PageContainerDisplay pageLocation(PageLocation location) {
        this.location = location;
        return this;
    }

    @Override
    public void refresh() {
        super.refresh();
        sendLocation();
    }

    private void sendLocation() {
        notifier.refreshLocation(location);
    }
}