package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.analytics.viewmodels.ElementView;
import io.intino.sumus.box.displays.providers.ElementViewDisplayProvider;
import io.intino.sumus.box.schemas.RecordItem;
import io.intino.sumus.graph.Mold;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Panel;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.functions.Tree;

import java.util.function.Consumer;

public interface ElementViewDisplay<P extends ElementViewDisplayProvider> {
	void provider(P provider);
	void onLoading(Consumer<Boolean> listener);
	ElementView view();
	void view(ElementView view);
	void refresh();
	void refresh(RecordItem... items);

	void onOpenItem(Consumer<OpenItemEvent> listener);
	void onOpenItemDialog(Consumer<OpenItemDialogEvent> listener);
	void onExecuteItemTask(Consumer<ExecuteItemTaskEvent> listener);

	interface OpenItemEvent {
		String item();
		String label();
		Record record();
		Panel panel();
		NameSpace nameSpace();
		TimeRange range();
		Tree breadcrumbs();
	}

	interface OpenItemDialogEvent {
		String item();
		String path();
		int width();
		int height();
	}

	interface ExecuteItemTaskEvent {
		String item();
		Mold.Block.Stamp stamp();
	}
}
