package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.builders.DialogBuilder;
import io.intino.sumus.box.displays.notifiers.DialogContainerDisplayNotifier;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class DialogContainerDisplay extends SumusDisplay<DialogContainerDisplayNotifier> {
    private int width;
    private int height;
    private String location;
    private List<Consumer<String>> assertionListeners = new ArrayList<>();

    public DialogContainerDisplay(SumusBox box) {
        super(box);
    }

    public void dialogWidth(int width) {
        this.width = width;
    }

    public void dialogHeight(int height) {
        this.height = height;
    }

    public void dialogLocation(String location) {
        this.location = location;
    }

    public void onDialogAssertion(Consumer<String> listener) {
        this.assertionListeners.add(listener);
    }

    @Override
    public void refresh() {
        super.refresh();
        sendInfo();
    }

    private void sendInfo() {
        notifier.refreshDialog(DialogBuilder.build(location, width, height));
    }

    public void dialogAssertionMade(String modification) {
        assertionListeners.forEach(l -> l.accept(modification));
    }

}