package io.intino.sumus.box.displays;

import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.notifiers.DesktopDisplayNotifier;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class DesktopDisplay extends SumusDisplay<DesktopDisplayNotifier> {
    private Map<Layout, Function<Layout, LayoutDisplay>> builders = new HashMap<>();

    private enum Layout {
        Tab, Menu
    }

    public DesktopDisplay(SumusBox box) {
        super(box);
        registerBuilders();
    }

    @Override
    protected void init() {
        super.init();
        Layout layout = platform().layout().isTab() ? Layout.Tab : Layout.Menu;
        add(builders.get(layout).apply(layout));
    }

    private void add(LayoutDisplay display) {
        addListeners(display);
        addAndPersonify(display);
    }

    private void addListeners(LayoutDisplay display) {
        display.onLoading(withMessage -> refreshLoading((Boolean) withMessage));
        display.onLoaded(value -> refreshLoaded());
    }

    private void refreshLoading(boolean withMessage) {
        notifier.loading(withMessage);
    }

    private void refreshLoaded() {
        notifier.loaded();
    }

    private void registerBuilders() {
        builders.put(Layout.Menu, layout -> new MenuLayoutDisplay(box));
        builders.put(Layout.Tab, layout -> new TabLayoutDisplay(box));
    }

}