package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.helpers.TimeScaleHandler;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.rules.TimeScale;

import java.util.List;

public abstract class ChartNavigatorDisplay<DN extends DisplayNotifier> extends SumusDisplay<DN> {
    private TimeScaleHandler timeScaleHandler;

    public ChartNavigatorDisplay(SumusBox box) {
        super(box);
    }

    public List<TimeScale> scales() {
        return timeScaleHandler.availableScales();
    }

    public TimeScaleHandler timeScaleHandler() {
        return timeScaleHandler;
    }

    public void timeScaleHandler(TimeScaleHandler timeScaleHandler) {
        this.timeScaleHandler = timeScaleHandler;
        addListeners(timeScaleHandler);
    }

    protected abstract void addListeners(TimeScaleHandler timeScaleHandler);

}