package io.intino.sumus.box.displays;

import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.box.SumusBox;

import java.util.*;

import static java.util.stream.Collectors.toList;

public abstract class CategorizationContainerDisplay<DN extends DisplayNotifier> extends SumusDisplay<DN> {
    private List<Categorization> categorizationList = new ArrayList<>();
    private List<TemporalCategorization> temporalCategorizationList = new ArrayList<>();
    private final Map<String, CategorizationDisplay> displayByCategorization = new HashMap<>();
    private List<TemporalCategorization> activeCategorizations = new ArrayList<>();

    public CategorizationContainerDisplay(SumusBox box) {
        super(box);
    }

    public void categorizations(List<Categorization> categorizations) {
        this.categorizationList = categorizations;
    }

    public void temporalCategorizations(List<TemporalCategorization> categorizations) {
        this.temporalCategorizationList = categorizations;
    }

    public void updateTemporalCategorizations(List<TemporalCategorization> activeCategorizations) {
        this.activeCategorizations = activeCategorizations;
        sendRefreshTemporalCategorizationList(temporalCategorizations());
    }

    @Override
    protected void init() {
        super.init();
        sendRefreshCategorizationList(categorizationList);
        sendRefreshTemporalCategorizationList(temporalCategorizationList);
        categorizationList.forEach(this::createCategorizationDisplay);
        temporalCategorizationList.forEach(this::createCategorizationDisplay);
    }

    protected abstract void sendRefreshCategorizationList(List<Categorization> categorizationList);
    protected abstract void sendRefreshTemporalCategorizationList(List<TemporalCategorization> categorizationList);
    protected abstract void addListeners(CategorizationDisplay categorizationDisplay);

    protected Collection<CategorizationDisplay> categorizationDisplays() {
        return displayByCategorization.values();
    }

    protected CategorizationDisplay categorizationDisplay(String name) {
        return displayByCategorization.get(name);
    }

    private List<TemporalCategorization> temporalCategorizations() {
        if (activeCategorizations.isEmpty()) return temporalCategorizationList;
        return activeCategorizations.stream().map(c -> (TemporalCategorization)c).collect(toList());
    }

    private void createCategorizationDisplay(Categorization categorization) {
        CategorizationDisplay display = new CategorizationDisplay(box);
        display.categorization(categorization);
        displayByCategorization.put(categorization.name$(), display);
        add(display);
        addListeners(display);
        display.personifyOnce(categorization.name$());
        display.refresh();
    }
}