package io.intino.sumus.box;

public class SumusConfiguration extends io.intino.konos.BoxConfiguration {

	PlatformActivityConfiguration platformConfiguration;

	public SumusConfiguration(String[] args) {
		super(args);
		fillWithArgs();
	}

	private void fillWithArgs() {
		if (this.store == null && args.get("graph_store") != null)
			store = new java.io.File(args.remove("graph_store"));
		if (args.containsKey("platform_port")) {
			platformConfiguration(toInt(args.remove("platform_port")), args.remove("platform_webDirectory"), args.remove("platform_federationUrl"), args.remove("platform_analyticsPath"));
			platformConfiguration.authService = SumusBox.authService(this.platformConfiguration.authServiceUrl());
		}
	}

	public java.io.File store() {
		return this.store;
	}

	public SumusConfiguration platformConfiguration(int port, String webDirectory, String federationUrl, String analyticsPath) {
		this.platformConfiguration = new PlatformActivityConfiguration();
		this.platformConfiguration.port = port;
		this.platformConfiguration.webDirectory = webDirectory == null ? "www/" : webDirectory;
		this.platformConfiguration.federationUrl = federationUrl;
		this.platformConfiguration.analyticsPath = analyticsPath;
		return this;
	}

	public SumusConfiguration platformConfiguration(int port, String federationUrl, String analyticsPath) {
		return platformConfiguration(port, "www/", federationUrl, analyticsPath);
	}

	public PlatformActivityConfiguration platformConfiguration() {
		return platformConfiguration;
	}

	public static class PlatformActivityConfiguration {
		public int port;
		public String webDirectory;
		public io.intino.konos.server.activity.services.AuthService authService;
		public String federationUrl = "";
		public String analyticsPath = "";

		public java.net.URL authServiceUrl() {
			try {
				return new java.net.URL("{federationUrl}".replace("{federationUrl}", federationUrl).replace("{analyticsPath}", analyticsPath));
			} catch (java.net.MalformedURLException e) {
				return null;
			}
		}
	}
}