package io.intino.sumus.box;

import io.intino.sumus.box.displays.*;
import io.intino.sumus.box.displays.notifiers.*;
import io.intino.sumus.box.displays.requesters.*;
import io.intino.sumus.box.resources.*;

import io.intino.konos.server.activity.ActivityKonosSpark;
import io.intino.konos.server.activity.displays.DisplayNotifier;
import io.intino.konos.server.activity.displays.DisplayNotifierProvider;
import io.intino.konos.server.activity.services.push.PushService;
import io.intino.konos.server.activity.spark.resources.AfterDisplayRequest;
import io.intino.konos.server.activity.spark.resources.AssetResource;
import io.intino.konos.server.activity.spark.resources.AuthenticateCallbackResource;
import io.intino.konos.server.activity.spark.resources.BeforeDisplayRequest;

import java.net.MalformedURLException;
import java.net.URL;

public class PlatformActivity extends io.intino.konos.server.activity.Activity {

	public static ActivityKonosSpark init(ActivityKonosSpark spark, SumusBox box) {
		SumusConfiguration.PlatformActivityConfiguration configuration = box.configuration().platformConfiguration;
		spark.route("/push").push(new PushService());
		spark.route("/authenticate-callback").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/asset/:name").get(manager -> new AssetResource(name -> new AssetResourceLoader(box).load(name), manager, notifierProvider()).execute());

		spark.route("{analyticsPath}".replace("{analyticsPath}", configuration.analyticsPath)).get(manager -> new AnalyticsPageResource(box, manager, notifierProvider()).execute());
		spark.route("/error").get(manager -> new ErrorPageResource(box, manager, notifierProvider()).execute());

		spark.route("/timebarchartdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timebarchartdialog/:displayId").post(manager -> new TimeBarChartDialogDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timebarchartdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/panelcustomview/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/panelcustomview/:displayId").post(manager -> new PanelCustomViewDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/panelcustomview/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timeserieschartdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timeserieschartdialog/:displayId").post(manager -> new TimeSeriesChartDialogDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timeserieschartdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timecrosstable/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timecrosstable/:displayId").post(manager -> new TimeCrossTableDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timecrosstable/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/panelolapview/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/panelolapview/:displayId").post(manager -> new PanelOlapViewDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/panelolapview/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/eventcatalog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/eventcatalog/:displayId").post(manager -> new EventCatalogDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/eventcatalog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/entitycatalog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/entitycatalog/:displayId").post(manager -> new EntityCatalogDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/entitycatalog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/analyze/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/analyze/:displayId").post(manager -> new AnalyzeDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/analyze/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timechartdesign/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timechartdesign/:displayId").post(manager -> new TimeChartDesignDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timechartdesign/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/record/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/record/:displayId").post(manager -> new RecordDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/record/:displayId").get(manager -> new RecordDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/record/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/menulayout/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/menulayout/:displayId").post(manager -> new MenuLayoutDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/menulayout/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/cataloglistview/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/cataloglistview/:displayId").post(manager -> new CatalogListViewDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/cataloglistview/:displayId").get(manager -> new CatalogListViewDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/cataloglistview/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/catalogmapview/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/catalogmapview/:displayId").post(manager -> new CatalogMapViewDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/catalogmapview/:displayId").get(manager -> new CatalogMapViewDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/catalogmapview/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/desktop/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/desktop/:displayId").post(manager -> new DesktopDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/desktop/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timeserieschart/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timeserieschart/:displayId").post(manager -> new TimeSeriesChartDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timeserieschart/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/catalogviewlist/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/catalogviewlist/:displayId").post(manager -> new CatalogViewListDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/catalogviewlist/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timenavigator/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timenavigator/:displayId").post(manager -> new TimeNavigatorDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timenavigator/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/catalogmagazineview/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/catalogmagazineview/:displayId").post(manager -> new CatalogMagazineViewDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/catalogmagazineview/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timecrosstabledialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timecrosstabledialog/:displayId").post(manager -> new TimeCrossTableDialogDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timecrosstabledialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/catalogolapview/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/catalogolapview/:displayId").post(manager -> new CatalogOlapViewDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/catalogolapview/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/tablayout/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/tablayout/:displayId").post(manager -> new TabLayoutDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/tablayout/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/dialogcontainer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/dialogcontainer/:displayId").post(manager -> new DialogContainerDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/dialogcontainer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/filterlist/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/filterlist/:displayId").post(manager -> new FilterListDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/filterlist/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/filter/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/filter/:displayId").post(manager -> new FilterDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/filter/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timerangenavigator/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timerangenavigator/:displayId").post(manager -> new TimeRangeNavigatorDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timerangenavigator/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/categorizationcomparator/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/categorizationcomparator/:displayId").post(manager -> new CategorizationComparatorDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/categorizationcomparator/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/olap/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/olap/:displayId").post(manager -> new OlapDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/olap/:displayId").get(manager -> new OlapDisplayRequester(manager, notifierProvider()).execute());
		spark.route("/olap/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/panel/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/panel/:displayId").post(manager -> new PanelDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/panel/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timescatterchartdialog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timescatterchartdialog/:displayId").post(manager -> new TimeScatterChartDialogDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timescatterchartdialog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/panelcatalogview/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/panelcatalogview/:displayId").post(manager -> new PanelCatalogViewDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/panelcatalogview/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/categorization/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/categorization/:displayId").post(manager -> new CategorizationDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/categorization/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/pagecontainer/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/pagecontainer/:displayId").post(manager -> new PageContainerDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/pagecontainer/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timescatterchart/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timescatterchart/:displayId").post(manager -> new TimeScatterChartDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timescatterchart/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/timebarchart/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/timebarchart/:displayId").post(manager -> new TimeBarChartDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/timebarchart/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/reportcatalog/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/reportcatalog/:displayId").post(manager -> new ReportCatalogDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/reportcatalog/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());
		spark.route("/error/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());
		spark.route("/error/:displayId").post(manager -> new ErrorDisplayRequester(manager, notifierProvider()).execute());

		spark.route("/error/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());


		registerNotifiers();
		return spark;
	}

	private static void registerNotifiers() {
		register(TimeBarChartDialogDisplayNotifier.class).forDisplay(TimeBarChartDialogDisplay.class);
		register(PanelCustomViewDisplayNotifier.class).forDisplay(PanelCustomViewDisplay.class);
		register(TimeSeriesChartDialogDisplayNotifier.class).forDisplay(TimeSeriesChartDialogDisplay.class);
		register(TimeCrossTableDisplayNotifier.class).forDisplay(TimeCrossTableDisplay.class);
		register(PanelOlapViewDisplayNotifier.class).forDisplay(PanelOlapViewDisplay.class);
		register(EventCatalogDisplayNotifier.class).forDisplay(EventCatalogDisplay.class);
		register(EntityCatalogDisplayNotifier.class).forDisplay(EntityCatalogDisplay.class);
		register(AnalyzeDisplayNotifier.class).forDisplay(AnalyzeDisplay.class);
		register(TimeChartDesignDisplayNotifier.class).forDisplay(TimeChartDesignDisplay.class);
		register(RecordDisplayNotifier.class).forDisplay(RecordDisplay.class);
		register(MenuLayoutDisplayNotifier.class).forDisplay(MenuLayoutDisplay.class);
		register(CatalogListViewDisplayNotifier.class).forDisplay(CatalogListViewDisplay.class);
		register(CatalogMapViewDisplayNotifier.class).forDisplay(CatalogMapViewDisplay.class);
		register(DesktopDisplayNotifier.class).forDisplay(DesktopDisplay.class);
		register(TimeSeriesChartDisplayNotifier.class).forDisplay(TimeSeriesChartDisplay.class);
		register(CatalogViewListDisplayNotifier.class).forDisplay(CatalogViewListDisplay.class);
		register(TimeNavigatorDisplayNotifier.class).forDisplay(TimeNavigatorDisplay.class);
		register(CatalogMagazineViewDisplayNotifier.class).forDisplay(CatalogMagazineViewDisplay.class);
		register(TimeCrossTableDialogDisplayNotifier.class).forDisplay(TimeCrossTableDialogDisplay.class);
		register(CatalogOlapViewDisplayNotifier.class).forDisplay(CatalogOlapViewDisplay.class);
		register(TabLayoutDisplayNotifier.class).forDisplay(TabLayoutDisplay.class);
		register(DialogContainerDisplayNotifier.class).forDisplay(DialogContainerDisplay.class);
		register(FilterListDisplayNotifier.class).forDisplay(FilterListDisplay.class);
		register(FilterDisplayNotifier.class).forDisplay(FilterDisplay.class);
		register(TimeRangeNavigatorDisplayNotifier.class).forDisplay(TimeRangeNavigatorDisplay.class);
		register(CategorizationComparatorDisplayNotifier.class).forDisplay(CategorizationComparatorDisplay.class);
		register(OlapDisplayNotifier.class).forDisplay(OlapDisplay.class);
		register(PanelDisplayNotifier.class).forDisplay(PanelDisplay.class);
		register(TimeScatterChartDialogDisplayNotifier.class).forDisplay(TimeScatterChartDialogDisplay.class);
		register(PanelCatalogViewDisplayNotifier.class).forDisplay(PanelCatalogViewDisplay.class);
		register(CategorizationDisplayNotifier.class).forDisplay(CategorizationDisplay.class);
		register(PageContainerDisplayNotifier.class).forDisplay(PageContainerDisplay.class);
		register(TimeScatterChartDisplayNotifier.class).forDisplay(TimeScatterChartDisplay.class);
		register(TimeBarChartDisplayNotifier.class).forDisplay(TimeBarChartDisplay.class);
		register(ReportCatalogDisplayNotifier.class).forDisplay(ReportCatalogDisplay.class);
		register(ErrorDisplayNotifier.class).forDisplay(ErrorDisplay.class);

	}
}