package io.intino.sumus.analytics.categorization.temporal;

import io.intino.sumus.graph.Categorization;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.TimeRange;
import io.intino.sumus.graph.rules.TimeScale;

public class DayCategorization extends TemporalCategorization {

    public DayCategorization(TimeRange range) {
        super("DayOfYearCategorization", "DayOfYear", parent(range), new TimeRange(range.from(), range.to(), TimeScale.Day));
    }

    private static Categorization parent(TimeRange range) {
        return new TemporalCategorization(new TimeRange(range.from(), range.to(), TimeScale.Week));
    }

}
