package io.intino.sumus.queries;

import io.intino.tara.magritte.Concept;

import java.util.Optional;

public class EntityQuery extends AbstractQuery {
	private Concept entity;
	private Scope scope = null;
	private String condition = null;
	private String username = null;

	private EntityQuery() {
	}

	public Concept entity() {
		return entity;
	}

	public String condition() {
		return condition;
	}

	public Optional<Scope> scope() {
		return Optional.ofNullable(scope);
	}

	public String username() {
		return username;
	}

	public static class Builder {
		private final EntityQuery query;

		public Builder() {
			query = new EntityQuery();
		}

		public EntityQuery build(Concept entity, String username) {
			query.entity = entity;
			query.username = username;
			return query;
		}

		public EntityQuery.Builder filter(Scope scope) {
			query.scope = scope;
			return this;
		}

		public EntityQuery.Builder condition(String condition) {
			query.condition = condition;
			return this;
		}
	}

}
