package io.intino.sumus.queries;

import io.intino.sumus.Category;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Record;
import io.intino.sumus.queries.digest.Query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractQuery {
    protected Scope scope = null;

    public void scope(Scope scope) {
        this.scope = scope;
    }

    protected Map<Categorization, List<Category>> toMap(List<io.intino.sumus.analytics.viewmodels.FilterCondition> filters) {
        Map<Categorization, List<io.intino.sumus.Category>> result = new HashMap<>();

        filters.forEach(fc -> {
            Categorization categorization = fc.categorization;
            List<io.intino.sumus.Category> categories = fc.categories;

            if (!result.containsKey(categorization))
                result.put(categorization, new ArrayList<>());

            List<io.intino.sumus.Category> categorizationCategories = result.get(categorization);
            categorizationCategories.removeAll(categories);
            categorizationCategories.addAll(categories);
        });

        return result;
    }

    protected void addScope(Query query) {
        if (scope == null) return;
        scope.categories().forEach(categories -> query.filter(categories.toArray(new Category[0])));
        scope.records().forEach(records -> query.filter(records.toArray(new Record[0])));
    }

    protected void addScope(io.intino.sumus.queries.temporalrecord.Query query) {
        if (scope == null) return;
        scope.categories().forEach(categories -> query.filter(categories.toArray(new Category[0])));
        scope.records().forEach(records -> query.filter(records.toArray(new Record[0])));
    }

}
