package io.intino.sumus.box.schemas;

public class ActivitySchemaAdapters {


	public static io.intino.sumus.box.schemas.PlatformInfo platformInfoFromLayer(io.intino.tara.magritte.Layer layer) {
		return platformInfoFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.PlatformInfo platformInfoFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.PlatformInfo schema = new io.intino.sumus.box.schemas.PlatformInfo();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("title")) schema.title((String) variables.get(variable).get(0).toString());
			if (variable.equals("subtitle")) schema.subtitle((String) variables.get(variable).get(0).toString());
			if (variable.equals("logo")) schema.logo((String) variables.get(variable).get(0).toString());
			if (variable.equals("authServiceUrl")) schema.authServiceUrl((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Olap olapFromLayer(io.intino.tara.magritte.Layer layer) {
		return olapFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Olap olapFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Olap schema = new io.intino.sumus.box.schemas.Olap();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("type")) schema.type((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.UserInfo userInfoFromLayer(io.intino.tara.magritte.Layer layer) {
		return userInfoFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.UserInfo userInfoFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.UserInfo schema = new io.intino.sumus.box.schemas.UserInfo();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("fullName")) schema.fullName((String) variables.get(variable).get(0).toString());
			if (variable.equals("photo")) schema.photo((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.RequestRange requestRangeFromLayer(io.intino.tara.magritte.Layer layer) {
		return requestRangeFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.RequestRange requestRangeFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.RequestRange schema = new io.intino.sumus.box.schemas.RequestRange();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("from")) schema.from((java.time.Instant) variables.get(variable).get(0));
			if (variable.equals("to")) schema.to((java.time.Instant) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Range rangeFromLayer(io.intino.tara.magritte.Layer layer) {
		return rangeFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Range rangeFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Range schema = new io.intino.sumus.box.schemas.Range();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("min")) schema.min((Double) variables.get(variable).get(0));
			if (variable.equals("max")) schema.max((Double) variables.get(variable).get(0));
			if (variable.equals("scale")) schema.scale((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Scale scaleFromLayer(io.intino.tara.magritte.Layer layer) {
		return scaleFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Scale scaleFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Scale schema = new io.intino.sumus.box.schemas.Scale();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("symbol")) schema.symbol((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Filter filterFromLayer(io.intino.tara.magritte.Layer layer) {
		return filterFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Filter filterFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Filter schema = new io.intino.sumus.box.schemas.Filter();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.FilterCategorization.class.getSimpleName())) schema.filterCategorizationList().add(filterCategorizationFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.FilterCategorization filterCategorizationFromLayer(io.intino.tara.magritte.Layer layer) {
		return filterCategorizationFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.FilterCategorization filterCategorizationFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.FilterCategorization schema = new io.intino.sumus.box.schemas.FilterCategorization();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("categories")) schema.categories().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.FilterDialog filterDialogFromLayer(io.intino.tara.magritte.Layer layer) {
		return filterDialogFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.FilterDialog filterDialogFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.FilterDialog schema = new io.intino.sumus.box.schemas.FilterDialog();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("filter")) schema.filter((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.FilterCondition filterConditionFromLayer(io.intino.tara.magritte.Layer layer) {
		return filterConditionFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.FilterCondition filterConditionFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.FilterCondition schema = new io.intino.sumus.box.schemas.FilterCondition();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Categorization.class.getSimpleName())) schema.categorization((categorizationFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Category.class.getSimpleName())) schema.categoryList().add(categoryFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Drill drillFromLayer(io.intino.tara.magritte.Layer layer) {
		return drillFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Drill drillFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Drill schema = new io.intino.sumus.box.schemas.Drill();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Categorization.class.getSimpleName())) schema.categorization((categorizationFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Category.class.getSimpleName())) schema.categoryList().add(categoryFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Categorization categorizationFromLayer(io.intino.tara.magritte.Layer layer) {
		return categorizationFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Categorization categorizationFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Categorization schema = new io.intino.sumus.box.schemas.Categorization();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Category categoryFromLayer(io.intino.tara.magritte.Layer layer) {
		return categoryFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Category categoryFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Category schema = new io.intino.sumus.box.schemas.Category();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.CategorizationView categorizationViewFromLayer(io.intino.tara.magritte.Layer layer) {
		return categorizationViewFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CategorizationView categorizationViewFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CategorizationView schema = new io.intino.sumus.box.schemas.CategorizationView();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.CategoryView.class.getSimpleName())) schema.categoryViewList().add(categoryViewFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.CategoryView categoryViewFromLayer(io.intino.tara.magritte.Layer layer) {
		return categoryViewFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CategoryView categoryViewFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CategoryView schema = new io.intino.sumus.box.schemas.CategoryView();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Formatter formatterFromLayer(io.intino.tara.magritte.Layer layer) {
		return formatterFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Formatter formatterFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Formatter schema = new io.intino.sumus.box.schemas.Formatter();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("format")) schema.format((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Event eventFromLayer(io.intino.tara.magritte.Layer layer) {
		return eventFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Event eventFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Event schema = new io.intino.sumus.box.schemas.Event();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("created")) schema.created((java.time.Instant) variables.get(variable).get(0));
			if (variable.equals("render")) schema.render((String) variables.get(variable).get(0).toString());
			if (variable.equals("icon")) schema.icon((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Serie serieFromLayer(io.intino.tara.magritte.Layer layer) {
		return serieFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Serie serieFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Serie schema = new io.intino.sumus.box.schemas.Serie();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("group")) schema.group((String) variables.get(variable).get(0).toString());
			if (variable.equals("metric")) schema.metric((String) variables.get(variable).get(0).toString());
			if (variable.equals("color")) schema.color((String) variables.get(variable).get(0).toString());
			if (variable.equals("style")) schema.style((String) variables.get(variable).get(0).toString());
			if (variable.equals("min")) schema.min((Integer) variables.get(variable).get(0));
			if (variable.equals("max")) schema.max((Integer) variables.get(variable).get(0));
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Data.class.getSimpleName())) schema.dataList().add(dataFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.DecimalPlaces.class.getSimpleName())) schema.decimalPlaces((decimalPlacesFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Data dataFromLayer(io.intino.tara.magritte.Layer layer) {
		return dataFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Data dataFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Data schema = new io.intino.sumus.box.schemas.Data();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("created")) schema.created((Double) variables.get(variable).get(0));
			if (variable.equals("value")) schema.value((Double) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.DecimalPlaces decimalPlacesFromLayer(io.intino.tara.magritte.Layer layer) {
		return decimalPlacesFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.DecimalPlaces decimalPlacesFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.DecimalPlaces schema = new io.intino.sumus.box.schemas.DecimalPlaces();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("absolute")) schema.absolute((Integer) variables.get(variable).get(0));
			if (variable.equals("percentage")) schema.percentage((Integer) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Points pointsFromLayer(io.intino.tara.magritte.Layer layer) {
		return pointsFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Points pointsFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Points schema = new io.intino.sumus.box.schemas.Points();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Serie.class.getSimpleName())) schema.serieList().add(serieFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Scale.class.getSimpleName())) schema.scale((scaleFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Histogram histogramFromLayer(io.intino.tara.magritte.Layer layer) {
		return histogramFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Histogram histogramFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Histogram schema = new io.intino.sumus.box.schemas.Histogram();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.CategoryView.class.getSimpleName())) schema.categoryViewList().add(categoryViewFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Ticket.class.getSimpleName())) schema.ticketList().add(ticketFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.HeatMap.class.getSimpleName())) schema.heatMap((heatMapFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.NameSpace nameSpaceFromLayer(io.intino.tara.magritte.Layer layer) {
		return nameSpaceFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.NameSpace nameSpaceFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.NameSpace schema = new io.intino.sumus.box.schemas.NameSpace();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Ticket ticketFromLayer(io.intino.tara.magritte.Layer layer) {
		return ticketFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Ticket ticketFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Ticket schema = new io.intino.sumus.box.schemas.Ticket();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("shortLabel")) schema.shortLabel((String) variables.get(variable).get(0).toString());
			if (variable.equals("color")) schema.color((String) variables.get(variable).get(0).toString());
			if (variable.equals("unit")) schema.unit((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Indicator.class.getSimpleName())) schema.indicatorList().add(indicatorFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Indicator indicatorFromLayer(io.intino.tara.magritte.Layer layer) {
		return indicatorFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Indicator indicatorFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Indicator schema = new io.intino.sumus.box.schemas.Indicator();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("color")) schema.color((String) variables.get(variable).get(0).toString());
			if (variable.equals("minValue")) schema.minValue((Double) variables.get(variable).get(0));
			if (variable.equals("maxValue")) schema.maxValue((Double) variables.get(variable).get(0));
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.DecimalPlaces.class.getSimpleName())) schema.decimalPlaces((decimalPlacesFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.CategorizationToggleDialog categorizationToggleDialogFromLayer(io.intino.tara.magritte.Layer layer) {
		return categorizationToggleDialogFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CategorizationToggleDialog categorizationToggleDialogFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CategorizationToggleDialog schema = new io.intino.sumus.box.schemas.CategorizationToggleDialog();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("categorization")) schema.categorization((String) variables.get(variable).get(0).toString());
			if (variable.equals("categories")) schema.categories().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.SortBy sortByFromLayer(io.intino.tara.magritte.Layer layer) {
		return sortByFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.SortBy sortByFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.SortBy schema = new io.intino.sumus.box.schemas.SortBy();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("ticket")) schema.ticket((String) variables.get(variable).get(0).toString());
			if (variable.equals("indicator")) schema.indicator((String) variables.get(variable).get(0).toString());
			if (variable.equals("mode")) schema.mode((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.CrossTableData crossTableDataFromLayer(io.intino.tara.magritte.Layer layer) {
		return crossTableDataFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CrossTableData crossTableDataFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CrossTableData schema = new io.intino.sumus.box.schemas.CrossTableData();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("unitLabel")) schema.unitLabel((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Column.class.getSimpleName())) schema.columnList().add(columnFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Row.class.getSimpleName())) schema.rowList().add(rowFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Entry.class.getSimpleName())) schema.entryList().add(entryFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.DecimalPlaces.class.getSimpleName())) schema.decimalPlaces((decimalPlacesFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.HeatMap.class.getSimpleName())) schema.heatMap((heatMapFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Column columnFromLayer(io.intino.tara.magritte.Layer layer) {
		return columnFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Column columnFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Column schema = new io.intino.sumus.box.schemas.Column();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("values")) schema.values().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Row rowFromLayer(io.intino.tara.magritte.Layer layer) {
		return rowFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Row rowFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Row schema = new io.intino.sumus.box.schemas.Row();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("values")) schema.values().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Entry entryFromLayer(io.intino.tara.magritte.Layer layer) {
		return entryFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Entry entryFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Entry schema = new io.intino.sumus.box.schemas.Entry();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));


		return schema;
	}


	public static io.intino.sumus.box.schemas.CrossTableQuery crossTableQueryFromLayer(io.intino.tara.magritte.Layer layer) {
		return crossTableQueryFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CrossTableQuery crossTableQueryFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CrossTableQuery schema = new io.intino.sumus.box.schemas.CrossTableQuery();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("cols")) schema.cols().addAll(((java.util.List<String>) variables.get(variable)));
			if (variable.equals("rows")) schema.rows().addAll(((java.util.List<String>) variables.get(variable)));
			if (variable.equals("ticket")) schema.ticket((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.HeatMap.class.getSimpleName())) schema.heatMap((heatMapFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.HeatMap heatMapFromLayer(io.intino.tara.magritte.Layer layer) {
		return heatMapFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.HeatMap heatMapFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.HeatMap schema = new io.intino.sumus.box.schemas.HeatMap();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("min")) schema.min((String) variables.get(variable).get(0).toString());
			if (variable.equals("max")) schema.max((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Label labelFromLayer(io.intino.tara.magritte.Layer layer) {
		return labelFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Label labelFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Label schema = new io.intino.sumus.box.schemas.Label();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Translation.class.getSimpleName())) schema.translationList().add(translationFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Translation translationFromLayer(io.intino.tara.magritte.Layer layer) {
		return translationFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Translation translationFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Translation schema = new io.intino.sumus.box.schemas.Translation();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("language")) schema.language((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.DateNavigatorState dateNavigatorStateFromLayer(io.intino.tara.magritte.Layer layer) {
		return dateNavigatorStateFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.DateNavigatorState dateNavigatorStateFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.DateNavigatorState schema = new io.intino.sumus.box.schemas.DateNavigatorState();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("playing")) schema.playing((Boolean) variables.get(variable).get(0));
			if (variable.equals("canPlay")) schema.canPlay((Boolean) variables.get(variable).get(0));
			if (variable.equals("canPrevious")) schema.canPrevious((Boolean) variables.get(variable).get(0));
			if (variable.equals("canNext")) schema.canNext((Boolean) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.ScatterQuery scatterQueryFromLayer(io.intino.tara.magritte.Layer layer) {
		return scatterQueryFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ScatterQuery scatterQueryFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ScatterQuery schema = new io.intino.sumus.box.schemas.ScatterQuery();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("xAxis")) schema.xAxis((String) variables.get(variable).get(0).toString());
			if (variable.equals("yAxis")) schema.yAxis((String) variables.get(variable).get(0).toString());
			if (variable.equals("radius")) schema.radius((String) variables.get(variable).get(0).toString());
			if (variable.equals("color")) schema.color((String) variables.get(variable).get(0).toString());
			if (variable.equals("categorization")) schema.categorization((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.HeatMap.class.getSimpleName())) schema.heatMap((heatMapFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Chart chartFromLayer(io.intino.tara.magritte.Layer layer) {
		return chartFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Chart chartFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Chart schema = new io.intino.sumus.box.schemas.Chart();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("options")) schema.options().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.ChartOption chartOptionFromLayer(io.intino.tara.magritte.Layer layer) {
		return chartOptionFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ChartOption chartOptionFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ChartOption schema = new io.intino.sumus.box.schemas.ChartOption();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("option")) schema.option((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.EventIcon eventIconFromLayer(io.intino.tara.magritte.Layer layer) {
		return eventIconFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.EventIcon eventIconFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.EventIcon schema = new io.intino.sumus.box.schemas.EventIcon();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("event")) schema.event((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Item itemFromLayer(io.intino.tara.magritte.Layer layer) {
		return itemFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Item itemFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Item schema = new io.intino.sumus.box.schemas.Item();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.ItemProperty.class.getSimpleName())) schema.itemPropertyList().add(itemPropertyFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.ItemProperty itemPropertyFromLayer(io.intino.tara.magritte.Layer layer) {
		return itemPropertyFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ItemProperty itemPropertyFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ItemProperty schema = new io.intino.sumus.box.schemas.ItemProperty();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Container containerFromLayer(io.intino.tara.magritte.Layer layer) {
		return containerFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Container containerFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Container schema = new io.intino.sumus.box.schemas.Container();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Catalog catalogFromLayer(io.intino.tara.magritte.Layer layer) {
		return catalogFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Catalog catalogFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Catalog schema = new io.intino.sumus.box.schemas.Catalog();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("embedded")) schema.embedded((Boolean) variables.get(variable).get(0));
			if (variable.equals("hideGroupings")) schema.hideGroupings((Boolean) variables.get(variable).get(0));
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Grouping.class.getSimpleName())) schema.groupingList().add(groupingFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Sorting.class.getSimpleName())) schema.sortingList().add(sortingFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Grouping groupingFromLayer(io.intino.tara.magritte.Layer layer) {
		return groupingFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Grouping groupingFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Grouping schema = new io.intino.sumus.box.schemas.Grouping();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("type")) schema.type((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("countItems")) schema.countItems((Integer) variables.get(variable).get(0));
			if (variable.equals("histogram")) schema.histogram((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Group.class.getSimpleName())) schema.groupList().add(groupFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Group groupFromLayer(io.intino.tara.magritte.Layer layer) {
		return groupFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Group groupFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Group schema = new io.intino.sumus.box.schemas.Group();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("selected")) schema.selected((Boolean) variables.get(variable).get(0));
			if (variable.equals("count")) schema.count((Integer) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Sorting sortingFromLayer(io.intino.tara.magritte.Layer layer) {
		return sortingFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Sorting sortingFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Sorting schema = new io.intino.sumus.box.schemas.Sorting();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("mode")) schema.mode((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.ElementView elementViewFromLayer(io.intino.tara.magritte.Layer layer) {
		return elementViewFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ElementView elementViewFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ElementView schema = new io.intino.sumus.box.schemas.ElementView();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("type")) schema.type((String) variables.get(variable).get(0).toString());
			if (variable.equals("embeddedElement")) schema.embeddedElement((Boolean) variables.get(variable).get(0));
			if (variable.equals("width")) schema.width((Integer) variables.get(variable).get(0));
			if (variable.equals("canSearch")) schema.canSearch((Boolean) variables.get(variable).get(0));
			if (variable.equals("canCreateClusters")) schema.canCreateClusters((Boolean) variables.get(variable).get(0));
			if (variable.equals("clusters")) schema.clusters().addAll(((java.util.List<String>) variables.get(variable)));
			if (variable.equals("emptyMessage")) schema.emptyMessage((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Toolbar.class.getSimpleName())) schema.toolbar((toolbarFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Mold.class.getSimpleName())) schema.mold((moldFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Center.class.getSimpleName())) schema.center((centerFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Zoom.class.getSimpleName())) schema.zoom((zoomFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Toolbar toolbarFromLayer(io.intino.tara.magritte.Layer layer) {
		return toolbarFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Toolbar toolbarFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Toolbar schema = new io.intino.sumus.box.schemas.Toolbar();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Operation.class.getSimpleName())) schema.operationList().add(operationFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Operation operationFromLayer(io.intino.tara.magritte.Layer layer) {
		return operationFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Operation operationFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Operation schema = new io.intino.sumus.box.schemas.Operation();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("title")) schema.title((String) variables.get(variable).get(0).toString());
			if (variable.equals("type")) schema.type((String) variables.get(variable).get(0).toString());
			if (variable.equals("icon")) schema.icon((String) variables.get(variable).get(0).toString());
			if (variable.equals("when")) schema.when((String) variables.get(variable).get(0).toString());
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Property.class.getSimpleName())) schema.propertyList().add(propertyFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Mold moldFromLayer(io.intino.tara.magritte.Layer layer) {
		return moldFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Mold moldFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Mold schema = new io.intino.sumus.box.schemas.Mold();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.MoldBlock.class.getSimpleName())) schema.moldBlockList().add(moldBlockFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Center centerFromLayer(io.intino.tara.magritte.Layer layer) {
		return centerFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Center centerFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Center schema = new io.intino.sumus.box.schemas.Center();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("latitude")) schema.latitude((Double) variables.get(variable).get(0));
			if (variable.equals("longitude")) schema.longitude((Double) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Zoom zoomFromLayer(io.intino.tara.magritte.Layer layer) {
		return zoomFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Zoom zoomFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Zoom schema = new io.intino.sumus.box.schemas.Zoom();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("min")) schema.min((Integer) variables.get(variable).get(0));
			if (variable.equals("max")) schema.max((Integer) variables.get(variable).get(0));
			if (variable.equals("defaultValue")) schema.defaultValue((Integer) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.MoldBlock moldBlockFromLayer(io.intino.tara.magritte.Layer layer) {
		return moldBlockFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.MoldBlock moldBlockFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.MoldBlock schema = new io.intino.sumus.box.schemas.MoldBlock();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("expanded")) schema.expanded((Boolean) variables.get(variable).get(0));
			if (variable.equals("layout")) schema.layout((String) variables.get(variable).get(0).toString());
			if (variable.equals("style")) schema.style((String) variables.get(variable).get(0).toString());
			if (variable.equals("width")) schema.width((Integer) variables.get(variable).get(0));
			if (variable.equals("height")) schema.height((Integer) variables.get(variable).get(0));
			if (variable.equals("hidden")) schema.hidden((Boolean) variables.get(variable).get(0));
			if (variable.equals("hiddenIfMobile")) schema.hiddenIfMobile((Boolean) variables.get(variable).get(0));
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Stamp.class.getSimpleName())) schema.stampList().add(stampFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.MoldBlock.class.getSimpleName())) schema.moldBlockList().add(moldBlockFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Stamp stampFromLayer(io.intino.tara.magritte.Layer layer) {
		return stampFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Stamp stampFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Stamp schema = new io.intino.sumus.box.schemas.Stamp();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("editable")) schema.editable((Boolean) variables.get(variable).get(0));
			if (variable.equals("shape")) schema.shape((String) variables.get(variable).get(0).toString());
			if (variable.equals("layout")) schema.layout((String) variables.get(variable).get(0).toString());
			if (variable.equals("height")) schema.height((Integer) variables.get(variable).get(0));
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Property.class.getSimpleName())) schema.propertyList().add(propertyFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.RecordItem recordItemFromLayer(io.intino.tara.magritte.Layer layer) {
		return recordItemFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.RecordItem recordItemFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.RecordItem schema = new io.intino.sumus.box.schemas.RecordItem();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("label")) schema.label((String) variables.get(variable).get(0).toString());
			if (variable.equals("group")) schema.group((java.time.Instant) variables.get(variable).get(0));
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.RecordItemStamp.class.getSimpleName())) schema.recordItemStampList().add(recordItemStampFromNode(component));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.RecordItemBlock.class.getSimpleName())) schema.recordItemBlockList().add(recordItemBlockFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.RecordItemStamp recordItemStampFromLayer(io.intino.tara.magritte.Layer layer) {
		return recordItemStampFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.RecordItemStamp recordItemStampFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.RecordItemStamp schema = new io.intino.sumus.box.schemas.RecordItemStamp();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("values")) schema.values().addAll(((java.util.List<String>) variables.get(variable)));
		}
		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Property.class.getSimpleName())) schema.propertyList().add(propertyFromNode(component));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.RecordItemBlock recordItemBlockFromLayer(io.intino.tara.magritte.Layer layer) {
		return recordItemBlockFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.RecordItemBlock recordItemBlockFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.RecordItemBlock schema = new io.intino.sumus.box.schemas.RecordItemBlock();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("hidden")) schema.hidden((Boolean) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Property propertyFromLayer(io.intino.tara.magritte.Layer layer) {
		return propertyFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Property propertyFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Property schema = new io.intino.sumus.box.schemas.Property();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.GroupingSelection groupingSelectionFromLayer(io.intino.tara.magritte.Layer layer) {
		return groupingSelectionFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.GroupingSelection groupingSelectionFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.GroupingSelection schema = new io.intino.sumus.box.schemas.GroupingSelection();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("groups")) schema.groups().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.GroupingGroup groupingGroupFromLayer(io.intino.tara.magritte.Layer layer) {
		return groupingGroupFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.GroupingGroup groupingGroupFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.GroupingGroup schema = new io.intino.sumus.box.schemas.GroupingGroup();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("grouping")) schema.grouping((String) variables.get(variable).get(0).toString());
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.Bounds boundsFromLayer(io.intino.tara.magritte.Layer layer) {
		return boundsFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Bounds boundsFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Bounds schema = new io.intino.sumus.box.schemas.Bounds();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.NorthEast.class.getSimpleName())) schema.northEast((northEastFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.SouthWest.class.getSimpleName())) schema.southWest((southWestFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.NorthEast northEastFromLayer(io.intino.tara.magritte.Layer layer) {
		return northEastFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.NorthEast northEastFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.NorthEast schema = new io.intino.sumus.box.schemas.NorthEast();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("longitude")) schema.longitude((Double) variables.get(variable).get(0));
			if (variable.equals("latitude")) schema.latitude((Double) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.SouthWest southWestFromLayer(io.intino.tara.magritte.Layer layer) {
		return southWestFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.SouthWest southWestFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.SouthWest schema = new io.intino.sumus.box.schemas.SouthWest();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("longitude")) schema.longitude((Double) variables.get(variable).get(0));
			if (variable.equals("latitude")) schema.latitude((Double) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.PageLocation pageLocationFromLayer(io.intino.tara.magritte.Layer layer) {
		return pageLocationFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.PageLocation pageLocationFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.PageLocation schema = new io.intino.sumus.box.schemas.PageLocation();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
			if (variable.equals("internal")) schema.internal((Boolean) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.ClusterGroup clusterGroupFromLayer(io.intino.tara.magritte.Layer layer) {
		return clusterGroupFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ClusterGroup clusterGroupFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ClusterGroup schema = new io.intino.sumus.box.schemas.ClusterGroup();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("name")) schema.name((String) variables.get(variable).get(0).toString());
			if (variable.equals("cluster")) schema.cluster((String) variables.get(variable).get(0).toString());
			if (variable.equals("entities")) schema.entities().addAll(((java.util.List<String>) variables.get(variable)));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.CatalogInstant catalogInstantFromLayer(io.intino.tara.magritte.Layer layer) {
		return catalogInstantFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.CatalogInstant catalogInstantFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.CatalogInstant schema = new io.intino.sumus.box.schemas.CatalogInstant();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("catalog")) schema.catalog((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((java.time.Instant) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.ElementOperationParameters elementOperationParametersFromLayer(io.intino.tara.magritte.Layer layer) {
		return elementOperationParametersFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ElementOperationParameters elementOperationParametersFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ElementOperationParameters schema = new io.intino.sumus.box.schemas.ElementOperationParameters();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("operation")) schema.operation((String) variables.get(variable).get(0).toString());
			if (variable.equals("option")) schema.option((String) variables.get(variable).get(0).toString());
			if (variable.equals("from")) schema.from((java.time.Instant) variables.get(variable).get(0));
			if (variable.equals("to")) schema.to((java.time.Instant) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.OpenItemDialogParameters openItemDialogParametersFromLayer(io.intino.tara.magritte.Layer layer) {
		return openItemDialogParametersFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.OpenItemDialogParameters openItemDialogParametersFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.OpenItemDialogParameters schema = new io.intino.sumus.box.schemas.OpenItemDialogParameters();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("item")) schema.item((String) variables.get(variable).get(0).toString());
			if (variable.equals("stamp")) schema.stamp((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.ExecuteItemTaskParameters executeItemTaskParametersFromLayer(io.intino.tara.magritte.Layer layer) {
		return executeItemTaskParametersFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ExecuteItemTaskParameters executeItemTaskParametersFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ExecuteItemTaskParameters schema = new io.intino.sumus.box.schemas.ExecuteItemTaskParameters();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("item")) schema.item((String) variables.get(variable).get(0).toString());
			if (variable.equals("stamp")) schema.stamp((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.DownloadItemParameters downloadItemParametersFromLayer(io.intino.tara.magritte.Layer layer) {
		return downloadItemParametersFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.DownloadItemParameters downloadItemParametersFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.DownloadItemParameters schema = new io.intino.sumus.box.schemas.DownloadItemParameters();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("stamp")) schema.stamp((String) variables.get(variable).get(0).toString());
			if (variable.equals("option")) schema.option((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.ExportItemParameters exportItemParametersFromLayer(io.intino.tara.magritte.Layer layer) {
		return exportItemParametersFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.ExportItemParameters exportItemParametersFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.ExportItemParameters schema = new io.intino.sumus.box.schemas.ExportItemParameters();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("stamp")) schema.stamp((String) variables.get(variable).get(0).toString());
			if (variable.equals("option")) schema.option((String) variables.get(variable).get(0).toString());
			if (variable.equals("from")) schema.from((java.time.Instant) variables.get(variable).get(0));
			if (variable.equals("to")) schema.to((java.time.Instant) variables.get(variable).get(0));
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.SaveItemParameters saveItemParametersFromLayer(io.intino.tara.magritte.Layer layer) {
		return saveItemParametersFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.SaveItemParameters saveItemParametersFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.SaveItemParameters schema = new io.intino.sumus.box.schemas.SaveItemParameters();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("stamp")) schema.stamp((String) variables.get(variable).get(0).toString());
			if (variable.equals("item")) schema.item((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.PictureData pictureDataFromLayer(io.intino.tara.magritte.Layer layer) {
		return pictureDataFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.PictureData pictureDataFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.PictureData schema = new io.intino.sumus.box.schemas.PictureData();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("item")) schema.item((String) variables.get(variable).get(0).toString());
			if (variable.equals("stamp")) schema.stamp((String) variables.get(variable).get(0).toString());
			if (variable.equals("value")) schema.value((String) variables.get(variable).get(0).toString());
		}

		return schema;
	}


	public static io.intino.sumus.box.schemas.RecordRefreshInfo recordRefreshInfoFromLayer(io.intino.tara.magritte.Layer layer) {
		return recordRefreshInfoFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.RecordRefreshInfo recordRefreshInfoFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.RecordRefreshInfo schema = new io.intino.sumus.box.schemas.RecordRefreshInfo();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));

		for (io.intino.tara.magritte.Node component : node.componentList()) {
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.Mold.class.getSimpleName())) schema.mold((moldFromNode(component)));
			if (component.name().equalsIgnoreCase(io.intino.sumus.box.schemas.RecordItem.class.getSimpleName())) schema.recordItem((recordItemFromNode(component)));
		}
		return schema;
	}


	public static io.intino.sumus.box.schemas.Dialog dialogFromLayer(io.intino.tara.magritte.Layer layer) {
		return dialogFromNode(layer.core$());
	}

	private static io.intino.sumus.box.schemas.Dialog dialogFromNode(io.intino.tara.magritte.Node node) {
		io.intino.sumus.box.schemas.Dialog schema = new io.intino.sumus.box.schemas.Dialog();
		final java.util.Map<String, java.util.List<?>> variables = node.variables();
		variables.put("name", java.util.Collections.singletonList(node.name()));
		variables.put("id", java.util.Collections.singletonList(node.id()));
		for (String variable : variables.keySet()) {
			if (variable.equals("location")) schema.location((String) variables.get(variable).get(0).toString());
			if (variable.equals("width")) schema.width((Integer) variables.get(variable).get(0));
			if (variable.equals("height")) schema.height((Integer) variables.get(variable).get(0));
		}

		return schema;
	}

}

